/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.experiment;

import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIMeasures;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.SteadyStateNSGAII;
import org.uma.jmetal.experiment.AlgorithmBuilder2;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class NSGAIIBuilder2<S extends Solution<?>, P extends Problem<S>>
implements AlgorithmBuilder2<S, P> {
    private P problem = null;
    private int maxIterations = 250;
    private int populationSize = 100;
    private CrossoverOperator<S> crossoverOperator;
    private MutationOperator<S> mutationOperator;
    private SelectionOperator<List<S>, S> selectionOperator;
    private SolutionListEvaluator<S> evaluator;
    private NSGAIIVariant2 variant;

    public NSGAIIBuilder2(CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, NSGAIIVariant2 variant) {
        this.crossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
        this.selectionOperator = new BinaryTournamentSelection();
        this.evaluator = new SequentialSolutionListEvaluator();
        this.variant = variant;
    }

    public NSGAIIBuilder2<S, P> setMaxIterations(int maxIterations) {
        if (maxIterations < 0) {
            throw new JMetalException("maxIterations is negative: " + maxIterations);
        }
        this.maxIterations = maxIterations;
        return this;
    }

    public NSGAIIBuilder2<S, P> setPopulationSize(int populationSize) {
        if (populationSize < 0) {
            throw new JMetalException("Population size is negative: " + populationSize);
        }
        this.populationSize = populationSize;
        return this;
    }

    public NSGAIIBuilder2<S, P> setSelectionOperator(SelectionOperator<List<S>, S> selectionOperator) {
        if (selectionOperator == null) {
            throw new JMetalException("selectionOperator is null");
        }
        this.selectionOperator = selectionOperator;
        return this;
    }

    public NSGAIIBuilder2<S, P> setSolutionListEvaluator(SolutionListEvaluator<S> evaluator) {
        if (evaluator == null) {
            throw new JMetalException("evaluator is null");
        }
        this.evaluator = evaluator;
        return this;
    }

    @Override
    public Algorithm<List<S>> build(P problem) {
        this.problem = problem;
        NSGAII algorithm = null;
        if (this.variant.equals((Object)NSGAIIVariant2.NSGAII)) {
            algorithm = new NSGAII(problem, this.maxIterations, this.populationSize, this.crossoverOperator, this.mutationOperator, this.selectionOperator, this.evaluator);
        } else if (this.variant.equals((Object)NSGAIIVariant2.SteadyStateNSGAII)) {
            algorithm = new SteadyStateNSGAII(problem, this.maxIterations, this.populationSize, this.crossoverOperator, this.mutationOperator, this.selectionOperator, this.evaluator);
        } else if (this.variant.equals((Object)NSGAIIVariant2.Measures)) {
            algorithm = new NSGAIIMeasures(problem, this.maxIterations, this.populationSize, this.crossoverOperator, this.mutationOperator, this.selectionOperator, this.evaluator);
        }
        return algorithm;
    }

    @Override
    public P getProblem() {
        return this.problem;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public CrossoverOperator<S> getCrossoverOperator() {
        return this.crossoverOperator;
    }

    public MutationOperator<S> getMutationOperator() {
        return this.mutationOperator;
    }

    public SelectionOperator<List<S>, S> getSelectionOperator() {
        return this.selectionOperator;
    }

    public SolutionListEvaluator<S> getSolutionListEvaluator() {
        return this.evaluator;
    }

    public static enum NSGAIIVariant2 {
        NSGAII,
        SteadyStateNSGAII,
        Measures;

    }
}

