/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.experiment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT1;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT2;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT3;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT4;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT6;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.experiment.ExperimentComponent;
import org.uma.jmetal.util.experiment.ExperimentConfiguration;
import org.uma.jmetal.util.experiment.ExperimentConfigurationBuilder;
import org.uma.jmetal.util.experiment.ExperimentalStudy;
import org.uma.jmetal.util.experiment.impl.AlgorithmExecution;

public class NSGAIIStudy {
    public NSGAIIStudy() {
        List<Problem<DoubleSolution>> problemList = Arrays.asList(new ZDT1(), new ZDT2(), new ZDT3(), new ZDT4(), new ZDT6());
        List<Algorithm<List<DoubleSolution>>> algorithmList = this.configureAlgorithmList(problemList);
        ExperimentConfiguration configuration = new ExperimentConfigurationBuilder("Experiment").setAlgorithmList(algorithmList).setProblemList(problemList).setExperimentBaseDirectory("/Users/antelverde/Softw/jMetal/jMetalGitHub/pruebas").setOutputParetoFrontFileName("FUN").setOutputParetoSetFileName("VAR").setIndependentRuns(4).build();
        AlgorithmExecution algorithmExecution = new AlgorithmExecution(configuration);
        ExperimentalStudy study = new ExperimentalStudy.Builder(configuration).addExperiment((ExperimentComponent)algorithmExecution).build();
        study.run();
    }

    List<Algorithm<List<DoubleSolution>>> configureAlgorithmList(List<Problem<DoubleSolution>> problemList) {
        ArrayList<Algorithm<List<DoubleSolution>>> algorithms = new ArrayList<Algorithm<List<DoubleSolution>>>();
        for (int i = 0; i < problemList.size(); ++i) {
            algorithms.add((Algorithm<List<DoubleSolution>>)new NSGAIIBuilder(problemList.get(i), (CrossoverOperator)new SBXCrossover(1.0, 20.0), (MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getNumberOfVariables(), 20.0), NSGAIIBuilder.NSGAIIVariant.NSGAII).build());
        }
        return algorithms;
    }
}

