/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.mochc.MOCHC;
import org.uma.jmetal.algorithm.multiobjective.mochc.MOCHCBuilder;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.HUXCrossover;
import org.uma.jmetal.operator.impl.mutation.BitFlipMutation;
import org.uma.jmetal.operator.impl.selection.RandomSelection;
import org.uma.jmetal.operator.impl.selection.RankingAndCrowdingSelection;
import org.uma.jmetal.problem.BinaryProblem;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionSetOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class MOCHCRunner {
    public static void main(String[] args) throws Exception {
        String problemName = args.length == 1 ? args[0] : "org.uma.jmetal.problem.multiobjective.zdt.ZDT5";
        BinaryProblem problem = (BinaryProblem)ProblemUtils.loadProblem((String)problemName);
        HUXCrossover crossoverOperator = new HUXCrossover(1.0);
        RandomSelection parentsSelection = new RandomSelection();
        RankingAndCrowdingSelection newGenerationSelection = new RankingAndCrowdingSelection(100);
        BitFlipMutation mutationOperator = new BitFlipMutation(0.35);
        MOCHC algorithm = new MOCHCBuilder(problem).setInitialConvergenceCount(0.25).setConvergenceValue(3).setPreservedPopulation(0.05).setPopulationSize(100).setMaxEvaluations(25000).setCrossover((CrossoverOperator)crossoverOperator).setNewGenerationSelection((SelectionOperator)newGenerationSelection).setCataclysmicMutation((MutationOperator)mutationOperator).setParentSelection((SelectionOperator)parentsSelection).setEvaluator((SolutionListEvaluator)new SequentialSolutionListEvaluator()).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm)algorithm).execute();
        List population = algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        new SolutionSetOutput.Printer(population).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
    }
}

