/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.moead.AbstractMOEAD;
import org.uma.jmetal.algorithm.multiobjective.moead.MOEADBuilder;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionSetOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class MOEADRunner {
    public static void main(String[] args) {
        String problemName = args.length == 1 ? args[0] : "org.uma.jmetal.problem.multiobjective.lz09.LZ09F2";
        DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem((String)problemName);
        double cr = 1.0;
        double f = 0.5;
        DifferentialEvolutionCrossover crossover = new DifferentialEvolutionCrossover(cr, f, "rand/1/bin");
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        AbstractMOEAD algorithm = new MOEADBuilder((Problem)problem, MOEADBuilder.Variant.MOEADDRA).setCrossover((CrossoverOperator)crossover).setMutation((MutationOperator)mutation).setMaxEvaluations(150000).setPopulationSize(300).setResultPopulationSize(300).setNeighborhoodSelectionProbability(0.9).setMaximumNumberOfReplacedSolutions(2).setNeighborSize(20).setFunctionType(AbstractMOEAD.FunctionType.TCHE).setDataDirectory("MOEAD_Weights").build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        new SolutionSetOutput.Printer(population).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
    }
}

