/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.multiobjective.ebes.Ebes;
import org.uma.jmetal.problem.multiobjective.ebes.EbesMutation;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionSetOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class NSGAIIEbesRunner {
    public static void main(String[] args) throws JMetalException {
        String problemName = "org.uma.jmetal.problem.multiobjective.ebes.Ebes";
        Problem problem = ProblemUtils.loadProblem((String)problemName);
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)((Ebes)problem).getnumberOfGroupElements();
        EbesMutation mutation = new EbesMutation(mutationProbability);
        BinaryTournamentSelection selection = new BinaryTournamentSelection();
        NSGAII algorithm = new NSGAIIBuilder(problem, (CrossoverOperator)crossover, (MutationOperator)mutation, NSGAIIBuilder.NSGAIIVariant.NSGAII).setSelectionOperator((SelectionOperator)selection).setMaxIterations(250).setPopulationSize(100).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        new SolutionSetOutput.Printer(population).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
    }
}

