/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIMeasures;
import org.uma.jmetal.measure.MeasureListener;
import org.uma.jmetal.measure.MeasureManager;
import org.uma.jmetal.measure.impl.BasicMeasure;
import org.uma.jmetal.measure.impl.CountingMeasure;
import org.uma.jmetal.measure.impl.DurationMeasure;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.multiobjective.Golinski;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionSetOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class NSGAIIMeasuresRunner {
    public static void main(String[] args) throws JMetalException, InterruptedException {
        Golinski problem;
        if (args.length == 1) {
            String problemName = args[0];
            problem = (DoubleProblem)ProblemUtils.loadProblem((String)problemName);
        } else {
            problem = new Golinski();
        }
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        BinaryTournamentSelection selection = new BinaryTournamentSelection((Comparator)new RankingAndCrowdingDistanceComparator());
        int maxIterations = 250;
        int populationSize = 100;
        NSGAII algorithm = new NSGAIIBuilder((Problem)problem, (CrossoverOperator)crossover, (MutationOperator)mutation, NSGAIIBuilder.NSGAIIVariant.Measures).setSelectionOperator((SelectionOperator)selection).setMaxIterations(maxIterations).setPopulationSize(populationSize).build();
        MeasureManager measureManager = ((NSGAIIMeasures)algorithm).getMeasureManager();
        CountingMeasure iteration = (CountingMeasure)measureManager.getPullMeasure((Object)"currentIteration");
        DurationMeasure currentComputingTime = (DurationMeasure)measureManager.getPullMeasure((Object)"currentExecutionTime");
        BasicMeasure nonDominatedSolutions = (BasicMeasure)measureManager.getPullMeasure((Object)"numberOfNonDominatedSolutionsInPopulation");
        BasicMeasure solutionListMeasure = (BasicMeasure)measureManager.getPushMeasure((Object)"currentPopulation");
        CountingMeasure iteration2 = (CountingMeasure)measureManager.getPushMeasure((Object)"currentIteration");
        BasicMeasure numberOfFeasibleSolutions = (BasicMeasure)measureManager.getPushMeasure((Object)"numberOfFeasibleSolutionsInPopulation");
        solutionListMeasure.register((MeasureListener)new Listener());
        iteration2.register((MeasureListener)new Listener2());
        numberOfFeasibleSolutions.register((MeasureListener)new feasibleSolutionsListener());
        Thread algorithmThread = new Thread((Runnable)algorithm);
        algorithmThread.start();
        int i = 0;
        while (iteration.get() < (long)maxIterations) {
            TimeUnit.SECONDS.sleep(5L);
            System.out.println("Iteration (" + i + ")                       : " + iteration.get());
            System.out.println("Computing time (" + i + ")                  : " + currentComputingTime.get());
            System.out.println("Number of Nondominated solutions (" + i + "): " + nonDominatedSolutions.get());
            ++i;
        }
        algorithmThread.join();
        List population = (List)algorithm.getResult();
        long computingTime = currentComputingTime.get();
        new SolutionSetOutput.Printer(population).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
    }

    private static class feasibleSolutionsListener
    implements MeasureListener<Integer> {
        private feasibleSolutionsListener() {
        }

        public synchronized void measureGenerated(Integer value) {
            System.out.println("Feasible solutions: " + value);
        }
    }

    private static class Listener2
    implements MeasureListener<Long> {
        private Listener2() {
        }

        public synchronized void measureGenerated(Long value) {
            if (value % 50L == 0L) {
                System.out.println("PUSH MEASURE. Iteration: " + value);
            }
        }
    }

    private static class Listener
    implements MeasureListener<List<DoubleSolution>> {
        private int counter = 0;

        private Listener() {
        }

        public synchronized void measureGenerated(List<DoubleSolution> solutions) {
            if (this.counter % 10 == 0) {
                System.out.println("PUSH MEASURE. Counter = " + this.counter + " First solution: " + solutions.get(0));
            }
            ++this.counter;
        }
    }
}

