/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.paes.PAES;
import org.uma.jmetal.algorithm.multiobjective.paes.PAESBuilder;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.multiobjective.ebes.Ebes;
import org.uma.jmetal.problem.multiobjective.ebes.EbesMutation;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionSetOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class PAESEbesRunner {
    public static void main(String[] args) throws JMetalException {
        String problemName = "org.uma.jmetal.problem.multiobjective.ebes.Ebes";
        Problem problem = ProblemUtils.loadProblem((String)problemName);
        double mutationProbability = 1.0 / (double)((Ebes)problem).getnumberOfGroupElements();
        EbesMutation mutation = new EbesMutation(mutationProbability);
        PAES algorithm = new PAESBuilder(problem).setMutationOperator((MutationOperator)mutation).setMaxEvaluations(10000).setArchiveSize(100).setBiSections(5).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        new SolutionSetOutput.Printer(population).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VARP.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUNP.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
    }
}

