/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.randomsearch.RandomSearch;
import org.uma.jmetal.algorithm.multiobjective.randomsearch.RandomSearchBuilder;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionSetOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class RandomSearchRunner {
    public static void main(String[] args) throws JMetalException {
        String problemName = args.length == 1 ? args[0] : "org.uma.jmetal.problem.multiobjective.Kursawe";
        Problem problem = ProblemUtils.loadProblem((String)problemName);
        RandomSearch algorithm = new RandomSearchBuilder(problem).setMaxEvaluations(2500000).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        new SolutionSetOutput.Printer(population).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
    }
}

