/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.workingTest;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.operator.impl.crossover.IntegerSBXCrossover;
import org.uma.jmetal.problem.IntegerProblem;
import org.uma.jmetal.problem.multiobjective.NMMin;
import org.uma.jmetal.solution.IntegerSolution;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionSetOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class IntegerSBXCrossoverWorkingTest {
    public static void main(String[] args) throws FileNotFoundException {
        if (args.length != 4) {
            System.err.println("Usage: numberOfSolutions granularity distributionIndex outputFile");
            System.exit(-1);
        }
        int numberOfPoints = Integer.valueOf(args[0]);
        int granularity = Integer.valueOf(args[1]);
        double distributionIndex = Double.valueOf(args[2]);
        String outputFileName = args[3];
        NMMin problem = new NMMin(1, -50, 50, -100, 100);
        IntegerSBXCrossover crossover = new IntegerSBXCrossover(1.0, distributionIndex);
        IntegerSolution solution1 = (IntegerSolution)problem.createSolution();
        IntegerSolution solution2 = (IntegerSolution)problem.createSolution();
        solution1.setVariableValue(0, (Object)-50);
        solution2.setVariableValue(0, (Object)50);
        List<IntegerSolution> parents = Arrays.asList(solution1, solution2);
        ArrayList<IntegerSolution> population = new ArrayList<IntegerSolution>(numberOfPoints);
        for (int i = 0; i < numberOfPoints; ++i) {
            List solutions = (List)crossover.execute(parents);
            population.add((IntegerSolution)solutions.get(0));
            population.add((IntegerSolution)solutions.get(1));
        }
        Collections.sort(population, new VariableComparator());
        new SolutionSetOutput.Printer(population).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("solutionsSBX")).print();
        double[][] classifier = IntegerSBXCrossoverWorkingTest.classify(population, (IntegerProblem)problem, granularity);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outputFileName)));
        try {
            for (int i = 0; i < classifier.length; ++i) {
                bufferedWriter.write(classifier[i][0] + "\t" + classifier[i][1]);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static double[][] classify(List<IntegerSolution> solutions, IntegerProblem problem, int granularity) {
        double grain = (problem.getUpperBound(0) - problem.getLowerBound(0)) / granularity;
        double[][] classifier = new double[granularity][];
        for (int i = 0; i < granularity; ++i) {
            classifier[i] = new double[2];
            classifier[i][0] = (double)problem.getLowerBound(0).intValue() + (double)i * grain;
            classifier[i][1] = 0.0;
        }
        for (IntegerSolution solution : solutions) {
            boolean found = false;
            int index = 0;
            while (!found) {
                if ((double)((Integer)solution.getVariableValue(0)).intValue() <= classifier[index][0]) {
                    double[] dArray = classifier[index];
                    dArray[1] = dArray[1] + 1.0;
                    found = true;
                    continue;
                }
                if (index == granularity - 1) {
                    double[] dArray = classifier[index];
                    dArray[1] = dArray[1] + 1.0;
                    found = true;
                    continue;
                }
                ++index;
            }
        }
        return classifier;
    }

    public static class VariableComparator
    implements Comparator<IntegerSolution> {
        @Override
        public int compare(IntegerSolution solution1, IntegerSolution solution2) {
            if (solution1 == null) {
                return 1;
            }
            if (solution2 == null) {
                return -1;
            }
            if ((Integer)solution1.getVariableValue(0) < (Integer)solution2.getVariableValue(0)) {
                return -1;
            }
            if ((Integer)solution1.getVariableValue(0) > (Integer)solution2.getVariableValue(0)) {
                return 1;
            }
            return 0;
        }
    }
}

