/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.randomsearch;

import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;

public class RandomSearch<S extends Solution<?>>
implements Algorithm<List<S>> {
    private Problem<S> problem;
    private int maxEvaluations;
    NonDominatedSolutionListArchive<S> nonDominatedArchive;

    public RandomSearch(Problem<S> problem, int maxEvaluations) {
        this.problem = problem;
        this.maxEvaluations = maxEvaluations;
        this.nonDominatedArchive = new NonDominatedSolutionListArchive();
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    @Override
    public void run() {
        int evaluations = 0;
        for (int i = 0; i < this.maxEvaluations; ++i) {
            S newSolution = this.problem.createSolution();
            this.problem.evaluate(newSolution);
            ++evaluations;
            this.nonDominatedArchive.add(newSolution);
        }
    }

    @Override
    public List<S> getResult() {
        return this.nonDominatedArchive.getSolutionList();
    }
}

