/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.singleobjective.evolutionstrategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.uma.jmetal.algorithm.impl.AbstractEvolutionStrategy;
import org.uma.jmetal.algorithm.singleobjective.evolutionstrategy.util.CMAESUtils;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.comparator.ObjectiveComparator;

public class CovarianceMatrixAdaptationEvolutionStrategy
extends AbstractEvolutionStrategy<DoubleSolution, DoubleSolution> {
    private Comparator<DoubleSolution> comparator;
    private int lambda;
    private int evaluations;
    private int maxEvaluations;
    private double[] typicalX;
    private DoubleProblem problem;
    private double[] distributionMean;
    private double sigma;
    private double[][] c;
    private double[] pathsC;
    private double[] pathsSigma;
    private int mu;
    private double[] weights;
    private double muEff;
    private double cumulationC;
    private double cumulationSigma;
    private double c1;
    private double cmu;
    private double dampingSigma;
    private double[][] b;
    private double[] diagD;
    private double[][] invSqrtC;
    private int eigenEval;
    private double chiN;
    private DoubleSolution bestSolutionEver = null;
    private Random rand;

    private CovarianceMatrixAdaptationEvolutionStrategy(Builder builder) {
        this.problem = builder.problem;
        this.lambda = builder.lambda;
        this.maxEvaluations = builder.maxEvaluations;
        this.typicalX = builder.typicalX;
        this.sigma = builder.sigma;
        long seed = System.currentTimeMillis();
        this.rand = new Random(seed);
        this.comparator = new ObjectiveComparator<DoubleSolution>(0);
        this.initializeInternalParameters();
    }

    public int getLambda() {
        return this.lambda;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    @Override
    protected void initProgress() {
        this.evaluations = 0;
    }

    @Override
    protected void updateProgress() {
        this.evaluations += this.lambda;
        this.updateInternalParameters();
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    @Override
    protected List<DoubleSolution> createInitialPopulation() {
        ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(this.lambda);
        for (int i = 0; i < this.lambda; ++i) {
            DoubleSolution newIndividual = (DoubleSolution)this.problem.createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    @Override
    protected List<DoubleSolution> evaluatePopulation(List<DoubleSolution> population) {
        for (DoubleSolution solution : population) {
            this.problem.evaluate(solution);
        }
        return population;
    }

    @Override
    protected List<DoubleSolution> selection(List<DoubleSolution> population) {
        return population;
    }

    @Override
    protected List<DoubleSolution> reproduction(List<DoubleSolution> population) {
        ArrayList<DoubleSolution> offspringPopulation = new ArrayList<DoubleSolution>(this.lambda);
        for (int iNk = 0; iNk < this.lambda; ++iNk) {
            offspringPopulation.add(this.sampleSolution());
        }
        return offspringPopulation;
    }

    @Override
    protected List<DoubleSolution> replacement(List<DoubleSolution> population, List<DoubleSolution> offspringPopulation) {
        return offspringPopulation;
    }

    @Override
    public DoubleSolution getResult() {
        return this.bestSolutionEver;
    }

    private void initializeInternalParameters() {
        int i;
        int i2;
        int numberOfVariables = this.problem.getNumberOfVariables();
        if (this.typicalX != null) {
            this.distributionMean = this.typicalX;
        } else {
            this.distributionMean = new double[numberOfVariables];
            for (int i3 = 0; i3 < numberOfVariables; ++i3) {
                this.distributionMean[i3] = this.rand.nextDouble();
            }
        }
        this.mu = (int)Math.floor(this.lambda / 2);
        this.weights = new double[this.mu];
        double sum = 0.0;
        for (i2 = 0; i2 < this.mu; ++i2) {
            this.weights[i2] = Math.log(this.mu + 0) - Math.log(i2 + 1);
            sum += this.weights[i2];
        }
        for (i2 = 0; i2 < this.mu; ++i2) {
            this.weights[i2] = this.weights[i2] / sum;
        }
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (i = 0; i < this.mu; ++i) {
            sum1 += this.weights[i];
            sum2 += this.weights[i] * this.weights[i];
        }
        this.muEff = sum1 * sum1 / sum2;
        this.cumulationC = (4.0 + this.muEff / (double)numberOfVariables) / ((double)(numberOfVariables + 4) + 2.0 * this.muEff / (double)numberOfVariables);
        this.cumulationSigma = (this.muEff + 2.0) / ((double)numberOfVariables + this.muEff + 5.0);
        this.c1 = 2.0 / (((double)numberOfVariables + 1.3) * ((double)numberOfVariables + 1.3) + this.muEff);
        this.cmu = Math.min(1.0 - this.c1, 2.0 * (this.muEff - 2.0 + 1.0 / this.muEff) / ((double)((numberOfVariables + 2) * (numberOfVariables + 2)) + this.muEff));
        this.dampingSigma = 1.0 + 2.0 * Math.max(0.0, Math.sqrt((this.muEff - 1.0) / (double)(numberOfVariables + 1)) - 1.0) + this.cumulationSigma;
        this.diagD = new double[numberOfVariables];
        this.pathsC = new double[numberOfVariables];
        this.pathsSigma = new double[numberOfVariables];
        this.b = new double[numberOfVariables][numberOfVariables];
        this.c = new double[numberOfVariables][numberOfVariables];
        this.invSqrtC = new double[numberOfVariables][numberOfVariables];
        for (i = 0; i < numberOfVariables; ++i) {
            int j;
            this.pathsC[i] = 0.0;
            this.pathsSigma[i] = 0.0;
            this.diagD[i] = 1.0;
            for (j = 0; j < numberOfVariables; ++j) {
                this.b[i][j] = 0.0;
                this.invSqrtC[i][j] = 0.0;
            }
            for (j = 0; j < i; ++j) {
                this.c[i][j] = 0.0;
            }
            this.b[i][i] = 1.0;
            this.c[i][i] = this.diagD[i] * this.diagD[i];
            this.invSqrtC[i][i] = 1.0;
        }
        this.eigenEval = 0;
        this.chiN = Math.sqrt(numberOfVariables) * (double)(1 - 1 / (4 * numberOfVariables) + 1 / (21 * numberOfVariables * numberOfVariables));
    }

    private void updateInternalParameters() {
        int numberOfVariables = this.problem.getNumberOfVariables();
        double[] oldDistributionMean = new double[numberOfVariables];
        System.arraycopy(this.distributionMean, 0, oldDistributionMean, 0, numberOfVariables);
        Collections.sort(this.getPopulation(), this.comparator);
        this.storeBest();
        this.updateDistributionMean();
        int hsig = this.updateEvolutionPaths(oldDistributionMean);
        this.adaptCovarianceMatrix(oldDistributionMean, hsig);
        double psxps = CMAESUtils.norm(this.pathsSigma);
        this.sigma *= Math.exp(this.cumulationSigma / this.dampingSigma * (Math.sqrt(psxps) / this.chiN - 1.0));
        this.decomposeCovarianceMatrix();
    }

    private void updateDistributionMean() {
        int numberOfVariables = this.problem.getNumberOfVariables();
        for (int i = 0; i < numberOfVariables; ++i) {
            this.distributionMean[i] = 0.0;
            for (int iNk = 0; iNk < this.mu; ++iNk) {
                double variableValue = (Double)((DoubleSolution)this.getPopulation().get(iNk)).getVariableValue(i);
                int n = i;
                this.distributionMean[n] = this.distributionMean[n] + this.weights[iNk] * variableValue;
            }
        }
    }

    private int updateEvolutionPaths(double[] oldDistributionMean) {
        int i;
        int numberOfVariables = this.problem.getNumberOfVariables();
        double[] artmp = new double[numberOfVariables];
        for (i = 0; i < numberOfVariables; ++i) {
            artmp[i] = 0.0;
            for (int j = 0; j < numberOfVariables; ++j) {
                int n = i;
                artmp[n] = artmp[n] + this.invSqrtC[i][j] * (this.distributionMean[j] - oldDistributionMean[j]) / this.sigma;
            }
        }
        for (i = 0; i < numberOfVariables; ++i) {
            this.pathsSigma[i] = (1.0 - this.cumulationSigma) * this.pathsSigma[i] + Math.sqrt(this.cumulationSigma * (2.0 - this.cumulationSigma) * this.muEff) * artmp[i];
        }
        double psxps = CMAESUtils.norm(this.pathsSigma);
        int hsig = 0;
        if (Math.sqrt(psxps) / Math.sqrt(1.0 - Math.pow(1.0 - this.cumulationSigma, 2.0 * (double)this.evaluations / (double)this.lambda)) / this.chiN < 1.4 + 2.0 / ((double)numberOfVariables + 1.0)) {
            hsig = 1;
        }
        for (int i2 = 0; i2 < numberOfVariables; ++i2) {
            this.pathsC[i2] = (1.0 - this.cumulationC) * this.pathsC[i2] + (double)hsig * Math.sqrt(this.cumulationC * (2.0 - this.cumulationC) * this.muEff) * (this.distributionMean[i2] - oldDistributionMean[i2]) / this.sigma;
        }
        return hsig;
    }

    private void adaptCovarianceMatrix(double[] oldDistributionMean, int hsig) {
        int numberOfVariables = this.problem.getNumberOfVariables();
        for (int i = 0; i < numberOfVariables; ++i) {
            for (int j = 0; j <= i; ++j) {
                this.c[i][j] = (1.0 - this.c1 - this.cmu) * this.c[i][j] + this.c1 * (this.pathsC[i] * this.pathsC[j] + (double)(1 - hsig) * this.cumulationC * (2.0 - this.cumulationC) * this.c[i][j]);
                for (int k = 0; k < this.mu; ++k) {
                    double valueI = (Double)((DoubleSolution)this.getPopulation().get(k)).getVariableValue(i);
                    double valueJ = (Double)((DoubleSolution)this.getPopulation().get(k)).getVariableValue(j);
                    double[] dArray = this.c[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.cmu * this.weights[k] * (valueI - oldDistributionMean[i]) * (valueJ - oldDistributionMean[j]) / this.sigma / this.sigma;
                }
            }
        }
    }

    private void decomposeCovarianceMatrix() {
        int numberOfVariables = this.problem.getNumberOfVariables();
        if ((double)(this.evaluations - this.eigenEval) > (double)this.lambda / (this.c1 + this.cmu) / (double)numberOfVariables / 10.0) {
            int j;
            int i;
            this.eigenEval = this.evaluations;
            for (int i2 = 0; i2 < numberOfVariables; ++i2) {
                for (int j2 = 0; j2 <= i2; ++j2) {
                    double d = this.c[i2][j2];
                    this.b[j2][i2] = d;
                    this.b[i2][j2] = d;
                }
            }
            double[] offdiag = new double[numberOfVariables];
            CMAESUtils.tred2(numberOfVariables, this.b, this.diagD, offdiag);
            CMAESUtils.tql2(numberOfVariables, this.diagD, offdiag, this.b);
            this.checkEigenCorrectness();
            double[][] artmp2 = new double[numberOfVariables][numberOfVariables];
            for (i = 0; i < numberOfVariables; ++i) {
                if (this.diagD[i] > 0.0) {
                    this.diagD[i] = Math.sqrt(this.diagD[i]);
                }
                for (j = 0; j < numberOfVariables; ++j) {
                    artmp2[i][j] = this.b[i][j] * (1.0 / this.diagD[j]);
                }
            }
            for (i = 0; i < numberOfVariables; ++i) {
                for (j = 0; j < numberOfVariables; ++j) {
                    this.invSqrtC[i][j] = 0.0;
                    for (int k = 0; k < numberOfVariables; ++k) {
                        double[] dArray = this.invSqrtC[i];
                        int n = j;
                        dArray[n] = dArray[n] + artmp2[i][k] * this.b[j][k];
                    }
                }
            }
        }
    }

    private void checkEigenCorrectness() {
        int numberOfVariables = this.problem.getNumberOfVariables();
        if (CMAESUtils.checkEigenSystem(numberOfVariables, this.c, this.diagD, this.b) > 0) {
            this.evaluations = this.maxEvaluations;
        }
        for (int i = 0; i < numberOfVariables; ++i) {
            if (!(this.diagD[i] < 0.0)) continue;
            JMetalLogger.logger.severe("CovarianceMatrixAdaptationEvolutionStrategy.updateDistribution: WARNING - an eigenvalue has become negative.");
            this.evaluations = this.maxEvaluations;
        }
    }

    private DoubleSolution sampleSolution() {
        int i;
        DoubleSolution solution = (DoubleSolution)this.problem.createSolution();
        int numberOfVariables = this.problem.getNumberOfVariables();
        double[] artmp = new double[numberOfVariables];
        for (i = 0; i < numberOfVariables; ++i) {
            artmp[i] = this.diagD[i] * this.rand.nextGaussian();
        }
        for (i = 0; i < numberOfVariables; ++i) {
            double sum = 0.0;
            for (int j = 0; j < numberOfVariables; ++j) {
                sum += this.b[i][j] * artmp[j];
            }
            double value = this.distributionMean[i] + this.sigma * sum;
            if (value > this.problem.getUpperBound(i)) {
                value = this.problem.getUpperBound(i);
            } else if (value < this.problem.getLowerBound(i)) {
                value = this.problem.getLowerBound(i);
            }
            solution.setVariableValue(i, value);
        }
        return solution;
    }

    private void storeBest() {
        if (this.bestSolutionEver == null || this.bestSolutionEver.getObjective(0) > ((DoubleSolution)this.getPopulation().get(0)).getObjective(0)) {
            this.bestSolutionEver = (DoubleSolution)this.getPopulation().get(0);
        }
    }

    public static class Builder {
        private static final int DEFAULT_LAMBDA = 10;
        private static final int DEFAULT_MAX_EVALUATIONS = 1000000;
        private static final double DEFAULT_SIGMA = 0.3;
        private DoubleProblem problem;
        private int lambda;
        private int maxEvaluations;
        private double[] typicalX;
        private double sigma;

        public Builder(DoubleProblem problem) {
            this.problem = problem;
            this.lambda = 10;
            this.maxEvaluations = 1000000;
            this.sigma = 0.3;
        }

        public Builder setLambda(int lambda) {
            this.lambda = lambda;
            return this;
        }

        public Builder setMaxEvaluations(int maxEvaluations) {
            this.maxEvaluations = maxEvaluations;
            return this;
        }

        public Builder setTypicalX(double[] typicalX) {
            this.typicalX = typicalX;
            return this;
        }

        public Builder setSigma(double sigma) {
            this.sigma = sigma;
            return this;
        }

        public CovarianceMatrixAdaptationEvolutionStrategy build() {
            return new CovarianceMatrixAdaptationEvolutionStrategy(this);
        }
    }
}

