/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.crossover;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.binarySet.BinarySet;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class HUXCrossover
implements CrossoverOperator<BinarySolution> {
    private double crossoverProbability;
    private JMetalRandom randomGenerator;

    public HUXCrossover(double crossoverProbability) {
        if (crossoverProbability < 0.0) {
            throw new JMetalException("Crossover probability is negative: " + crossoverProbability);
        }
        this.crossoverProbability = crossoverProbability;
        this.randomGenerator = JMetalRandom.getInstance();
    }

    public double getCrossoverProbability() {
        return this.crossoverProbability;
    }

    @Override
    public List<BinarySolution> execute(List<BinarySolution> parents) {
        if (parents.size() != 2) {
            throw new JMetalException("HUXCrossover.execute: operator needs two parents");
        }
        return this.doCrossover(this.crossoverProbability, parents.get(0), parents.get(1));
    }

    public List<BinarySolution> doCrossover(double probability, BinarySolution parent1, BinarySolution parent2) throws JMetalException {
        if (this.randomGenerator.nextDouble() < probability) {
            for (int var = 0; var < parent1.getNumberOfVariables(); ++var) {
                BitSet p1 = (BitSet)parent1.getVariableValue(var);
                BitSet p2 = (BitSet)parent1.getVariableValue(var);
                for (int bit = 0; bit < parent1.getNumberOfBits(var); ++bit) {
                    if (p1.get(bit) == p2.get(bit) || !(this.randomGenerator.nextDouble() < 0.5)) continue;
                    ((BinarySet)parent1.getVariableValue(var)).set(bit, p2.get(bit));
                    ((BinarySet)parent2.getVariableValue(var)).set(bit, p1.get(bit));
                }
            }
        }
        ArrayList<BinarySolution> offSpring = new ArrayList<BinarySolution>();
        offSpring.add(parent1);
        offSpring.add(parent2);
        return offSpring;
    }
}

