/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.workingTest;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.operator.impl.mutation.IntegerPolynomialMutation;
import org.uma.jmetal.problem.IntegerProblem;
import org.uma.jmetal.problem.singleobjective.NIntegerMin;
import org.uma.jmetal.solution.IntegerSolution;

public class IntegerPolynomialMutationWorkingTest {
    public static void main(String[] args) throws FileNotFoundException {
        String outputFileName;
        double distributionIndex;
        int granularity;
        int numberOfPoints;
        if (args.length != 4) {
            System.out.println("Usage: numberOfSolutions granularity distributionIndex outputFile");
            System.out.println("Using default parameters");
            numberOfPoints = 10000;
            granularity = 100;
            distributionIndex = 20.0;
            outputFileName = "integerPolynomialData.txt";
        } else {
            numberOfPoints = Integer.valueOf(args[0]);
            granularity = Integer.valueOf(args[1]);
            distributionIndex = Double.valueOf(args[2]);
            outputFileName = args[3];
        }
        NIntegerMin problem = new NIntegerMin(1, 10, -1000, 1000);
        IntegerPolynomialMutation mutation = new IntegerPolynomialMutation(1.0, distributionIndex);
        IntegerSolution solution = (IntegerSolution)problem.createSolution();
        solution.setVariableValue(0, 0);
        ArrayList<IntegerSolution> population = new ArrayList<IntegerSolution>(numberOfPoints);
        for (int i = 0; i < numberOfPoints; ++i) {
            IntegerSolution newSolution = (IntegerSolution)solution.copy();
            mutation.execute(newSolution);
            population.add(newSolution);
        }
        Collections.sort(population, new VariableComparator());
        double[][] classifier = IntegerPolynomialMutationWorkingTest.classify(population, problem, granularity);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outputFileName)));
        try {
            for (int i = 0; i < classifier.length; ++i) {
                bufferedWriter.write(classifier[i][0] + "\t" + classifier[i][1]);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static double[][] classify(List<IntegerSolution> solutions, IntegerProblem problem, int granularity) {
        double grain = (problem.getUpperBound(0) - problem.getLowerBound(0)) / granularity;
        double[][] classifier = new double[granularity][];
        for (int i = 0; i < granularity; ++i) {
            classifier[i] = new double[2];
            classifier[i][0] = (double)problem.getLowerBound(0).intValue() + (double)i * grain;
            classifier[i][1] = 0.0;
        }
        for (IntegerSolution solution : solutions) {
            boolean found = false;
            int index = 0;
            while (!found) {
                if ((double)((Integer)solution.getVariableValue(0)).intValue() <= classifier[index][0]) {
                    double[] dArray = classifier[index];
                    dArray[1] = dArray[1] + 1.0;
                    found = true;
                    continue;
                }
                if (index == granularity - 1) {
                    double[] dArray = classifier[index];
                    dArray[1] = dArray[1] + 1.0;
                    found = true;
                    continue;
                }
                ++index;
            }
        }
        return classifier;
    }

    public static class VariableComparator
    implements Comparator<IntegerSolution> {
        @Override
        public int compare(IntegerSolution solution1, IntegerSolution solution2) {
            if (solution1 == null) {
                return 1;
            }
            if (solution2 == null) {
                return -1;
            }
            if ((Integer)solution1.getVariableValue(0) < (Integer)solution2.getVariableValue(0)) {
                return -1;
            }
            if ((Integer)solution1.getVariableValue(0) > (Integer)solution2.getVariableValue(0)) {
                return 1;
            }
            return 0;
        }
    }
}

