/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.dmopso;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class DMOPSO
implements Algorithm<List<DoubleSolution>> {
    private static final long serialVersionUID = 1L;
    private DoubleProblem problem;
    private List<DoubleSolution> swarm;
    private double c1Max;
    private double c1Min;
    private double c2Max;
    private double c2Min;
    private double r1Max;
    private double r1Min;
    private double r2Max;
    private double r2Min;
    private double weightMax;
    private double weightMin;
    private double changeVelocity1;
    private double changeVelocity2;
    private int swarmSize;
    private int maxIterations;
    private int iterations;
    private int maxAge;
    private DoubleSolution[] localBest;
    private DoubleSolution[] globalBest;
    private int[] shfGBest;
    private double[][] speed;
    private int[] age;
    double[] z;
    double[][] lambda;
    DoubleSolution[] indArray;
    private double[] deltaMax;
    private double[] deltaMin;
    String dataDirectory;
    String functionType = "_PBI";
    private JMetalRandom randomGenerator;
    private SolutionListEvaluator<DoubleSolution> evaluator;

    public DMOPSO(DoubleProblem problem, int swarmSize, int maxIterations, double r1Min, double r1Max, double r2Min, double r2Max, double c1Min, double c1Max, double c2Min, double c2Max, double weightMin, double weightMax, double changeVelocity1, double changeVelocity2, String functionType, String dataDirectory, int maxAge) {
        this.problem = problem;
        this.swarmSize = swarmSize;
        this.maxIterations = maxIterations;
        this.r1Max = r1Max;
        this.r1Min = r1Min;
        this.r2Max = r2Max;
        this.r2Min = r2Min;
        this.c1Max = c1Max;
        this.c1Min = c1Min;
        this.c2Max = c2Max;
        this.c2Min = c2Min;
        this.weightMax = weightMax;
        this.weightMin = weightMin;
        this.changeVelocity1 = changeVelocity1;
        this.changeVelocity2 = changeVelocity2;
        this.functionType = functionType;
        this.maxAge = maxAge;
        this.dataDirectory = dataDirectory;
        this.evaluator = new SequentialSolutionListEvaluator<DoubleSolution>();
        this.randomGenerator = JMetalRandom.getInstance();
        this.localBest = new DoubleSolution[swarmSize];
        this.globalBest = new DoubleSolution[swarmSize];
        this.shfGBest = new int[swarmSize];
        this.speed = new double[swarmSize][problem.getNumberOfVariables()];
        this.age = new int[swarmSize];
        this.indArray = new DoubleSolution[problem.getNumberOfObjectives()];
        this.z = new double[problem.getNumberOfObjectives()];
        this.lambda = new double[swarmSize][problem.getNumberOfObjectives()];
        this.deltaMax = new double[problem.getNumberOfVariables()];
        this.deltaMin = new double[problem.getNumberOfVariables()];
        for (int i = 0; i < problem.getNumberOfVariables(); ++i) {
            this.deltaMax[i] = (problem.getUpperBound(i) - problem.getLowerBound(i)) / 2.0;
            this.deltaMin[i] = -this.deltaMax[i];
        }
    }

    public List<DoubleSolution> getSwarm() {
        return this.swarm;
    }

    protected void initProgress() {
        this.iterations = 1;
    }

    protected void updateProgress() {
        ++this.iterations;
    }

    protected boolean isStoppingConditionReached() {
        return this.iterations >= this.maxIterations;
    }

    protected List<DoubleSolution> createInitialSwarm() {
        ArrayList<DoubleSolution> swarm = new ArrayList<DoubleSolution>(this.swarmSize);
        for (int i = 0; i < this.swarmSize; ++i) {
            DoubleSolution newSolution = (DoubleSolution)this.problem.createSolution();
            swarm.add(newSolution);
        }
        return swarm;
    }

    protected List<DoubleSolution> evaluateSwarm(List<DoubleSolution> swarm) {
        swarm = this.evaluator.evaluate(swarm, this.problem);
        return swarm;
    }

    protected void initializeLeaders(List<DoubleSolution> swarm) {
        for (int i = 0; i < this.getSwarm().size(); ++i) {
            DoubleSolution particle;
            this.globalBest[i] = particle = (DoubleSolution)this.getSwarm().get(i).copy();
        }
        this.updateGlobalBest();
    }

    protected void initializeParticlesMemory(List<DoubleSolution> swarm) {
        for (int i = 0; i < this.getSwarm().size(); ++i) {
            DoubleSolution particle;
            this.localBest[i] = particle = (DoubleSolution)this.getSwarm().get(i).copy();
        }
    }

    protected void initializeVelocity(List<DoubleSolution> swarm) {
        for (int i = 0; i < this.swarmSize; ++i) {
            for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
                this.speed[i][j] = 0.0;
            }
            this.age[i] = 0;
        }
    }

    protected void updateVelocity(int i) {
        DoubleSolution particle = this.getSwarm().get(i);
        DoubleSolution bestParticle = this.localBest[i];
        DoubleSolution bestGlobal = this.globalBest[this.shfGBest[i]];
        double r1 = this.randomGenerator.nextDouble(this.r1Min, this.r1Max);
        double r2 = this.randomGenerator.nextDouble(this.r2Min, this.r2Max);
        double C1 = this.randomGenerator.nextDouble(this.c1Min, this.c1Max);
        double C2 = this.randomGenerator.nextDouble(this.c2Min, this.c2Max);
        for (int var = 0; var < particle.getNumberOfVariables(); ++var) {
            this.speed[i][var] = this.velocityConstriction(this.constrictionCoefficient(C1, C2) * (this.inertiaWeight(this.iterations, this.maxIterations, this.weightMax, this.weightMin) * this.speed[i][var] + C1 * r1 * ((Double)bestParticle.getVariableValue(var) - (Double)particle.getVariableValue(var)) + C2 * r2 * ((Double)bestGlobal.getVariableValue(var) - (Double)particle.getVariableValue(var))), this.deltaMax, this.deltaMin, var, i);
        }
    }

    private void computeNewPositions(int i) {
        DoubleSolution particle = this.getSwarm().get(i);
        for (int var = 0; var < particle.getNumberOfVariables(); ++var) {
            particle.setVariableValue(var, (Double)particle.getVariableValue(var) + this.speed[i][var]);
        }
    }

    private void initUniformWeight() {
        if (this.problem.getNumberOfObjectives() == 2 && this.swarmSize < 300) {
            for (int n = 0; n < this.swarmSize; ++n) {
                double a;
                this.lambda[n][0] = a = 1.0 * (double)n / (double)(this.swarmSize - 1);
                this.lambda[n][1] = 1.0 - a;
            }
        } else {
            this.dataDirectory = "/Users/antelverde/Softw/pruebas/data/MOEAD_parameters/Weight";
            String dataFileName = "W" + this.problem.getNumberOfObjectives() + "D_" + this.swarmSize + ".dat";
            try {
                FileInputStream fis = new FileInputStream(this.dataDirectory + "/" + dataFileName);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                int i = 0;
                int j = 0;
                String aux = br.readLine();
                while (aux != null) {
                    StringTokenizer st = new StringTokenizer(aux);
                    j = 0;
                    while (st.hasMoreTokens()) {
                        double value;
                        this.lambda[i][j] = value = new Double(st.nextToken()).doubleValue();
                        ++j;
                    }
                    aux = br.readLine();
                    ++i;
                }
                br.close();
            }
            catch (Exception e) {
                throw new JMetalException("initUniformWeight: failed when reading for file: " + this.dataDirectory + "/" + dataFileName);
            }
        }
    }

    private void initIdealPoint() {
        int i;
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            this.z[i] = 1.0E30;
            this.indArray[i] = (DoubleSolution)this.problem.createSolution();
            this.problem.evaluate(this.indArray[i]);
        }
        for (i = 0; i < this.swarmSize; ++i) {
            this.updateReference(this.getSwarm().get(i));
        }
    }

    private void updateReference(DoubleSolution individual) {
        for (int n = 0; n < this.problem.getNumberOfObjectives(); ++n) {
            if (!(individual.getObjective(n) < this.z[n])) continue;
            this.z[n] = individual.getObjective(n);
            this.indArray[n] = (DoubleSolution)individual.copy();
        }
    }

    private void updateGlobalBest() {
        for (int j = 0; j < this.lambda.length; ++j) {
            double gBestFitness = this.fitnessFunction(this.globalBest[j], this.lambda[j]);
            for (int i = 0; i < this.getSwarm().size(); ++i) {
                double v2;
                double v1 = this.fitnessFunction(this.getSwarm().get(i), this.lambda[j]);
                if (!(v1 < (v2 = gBestFitness))) continue;
                this.globalBest[j] = (DoubleSolution)this.getSwarm().get(i).copy();
                gBestFitness = v1;
            }
        }
    }

    private void updateLocalBest(int part) {
        DoubleSolution indiv = (DoubleSolution)this.getSwarm().get(part).copy();
        double f1 = this.fitnessFunction(this.localBest[part], this.lambda[part]);
        double f2 = this.fitnessFunction(indiv, this.lambda[part]);
        if (this.age[part] >= this.maxAge || f2 <= f1) {
            this.localBest[part] = indiv;
            this.age[part] = 0;
        } else {
            int n = part;
            this.age[n] = this.age[n] + 1;
        }
    }

    private double fitnessFunction(DoubleSolution sol, double[] lambda) {
        double fitness = 0.0;
        if (this.functionType.equals("_TCHE")) {
            double maxFun = -1.0E30;
            for (int n = 0; n < this.problem.getNumberOfObjectives(); ++n) {
                double diff = Math.abs(sol.getObjective(n) - this.z[n]);
                double feval = lambda[n] == 0.0 ? 1.0E-4 * diff : diff * lambda[n];
                if (!(feval > maxFun)) continue;
                maxFun = feval;
            }
            fitness = maxFun;
        } else if (this.functionType.equals("_AGG")) {
            double sum = 0.0;
            for (int n = 0; n < this.problem.getNumberOfObjectives(); ++n) {
                sum += lambda[n] * sol.getObjective(n);
            }
            fitness = sum;
        } else if (this.functionType.equals("_PBI")) {
            int i;
            double theta = 5.0;
            double nl = 0.0;
            double d2 = 0.0;
            double d1 = 0.0;
            for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
                d1 += (sol.getObjective(i) - this.z[i]) * lambda[i];
                nl += Math.pow(lambda[i], 2.0);
            }
            nl = Math.sqrt(nl);
            d1 = Math.abs(d1) / nl;
            for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
                d2 += Math.pow(sol.getObjective(i) - this.z[i] - d1 * (lambda[i] / nl), 2.0);
            }
            d2 = Math.sqrt(d2);
            fitness = d1 + theta * d2;
        } else {
            System.out.println("dMOPSO.fitnessFunction: unknown type " + this.functionType);
            System.exit(-1);
        }
        return fitness;
    }

    private void shuffleGlobalBest() {
        int i;
        int[] aux = new int[this.swarmSize];
        for (i = 0; i < this.swarmSize; ++i) {
            aux[i] = i;
        }
        for (i = 0; i < this.swarmSize; ++i) {
            int rnd = this.randomGenerator.nextInt(i, this.swarmSize - 1);
            int tmp = aux[rnd];
            aux[rnd] = aux[i];
            this.shfGBest[i] = tmp;
        }
    }

    private void repairBounds(int part) {
        DoubleSolution particle = this.getSwarm().get(part);
        for (int var = 0; var < particle.getNumberOfVariables(); ++var) {
            if ((Double)particle.getVariableValue(var) < this.problem.getLowerBound(var)) {
                particle.setVariableValue(var, this.problem.getLowerBound(var));
                this.speed[part][var] = this.speed[part][var] * this.changeVelocity1;
            }
            if (!((Double)particle.getVariableValue(var) > this.problem.getUpperBound(var))) continue;
            particle.setVariableValue(var, this.problem.getUpperBound(var));
            this.speed[part][var] = this.speed[part][var] * this.changeVelocity2;
        }
    }

    private void resetParticle(int i) {
        DoubleSolution particle = this.getSwarm().get(i);
        for (int var = 0; var < particle.getNumberOfVariables(); ++var) {
            DoubleSolution gB = this.globalBest[this.shfGBest[i]];
            DoubleSolution pB = this.localBest[i];
            double mean = ((Double)gB.getVariableValue(var) - (Double)pB.getVariableValue(var)) / 2.0;
            double sigma = Math.abs((Double)gB.getVariableValue(var) - (Double)pB.getVariableValue(var));
            Random rnd = new Random();
            double N = rnd.nextGaussian() * sigma + mean;
            particle.setVariableValue(var, N);
            this.speed[i][var] = 0.0;
        }
    }

    private double velocityConstriction(double v, double[] deltaMax, double[] deltaMin, int variableIndex, int particleIndex) {
        double dmax = deltaMax[variableIndex];
        double dmin = deltaMin[variableIndex];
        double result = v;
        if (v > dmax) {
            result = dmax;
        }
        if (v < dmin) {
            result = dmin;
        }
        return result;
    }

    private double constrictionCoefficient(double c1, double c2) {
        double rho = c1 + c2;
        if (rho <= 4.0) {
            return 1.0;
        }
        return 2.0 / (2.0 - rho - Math.sqrt(Math.pow(rho, 2.0) - 4.0 * rho));
    }

    private double inertiaWeight(int iter, int miter, double wma, double wmin) {
        return wma;
    }

    @Override
    public void run() {
        this.swarm = this.createInitialSwarm();
        this.evaluateSwarm(this.swarm);
        this.initializeVelocity(this.getSwarm());
        this.initUniformWeight();
        this.initIdealPoint();
        this.initializeLeaders(this.getSwarm());
        this.initializeParticlesMemory(this.getSwarm());
        this.updateGlobalBest();
        this.initProgress();
        while (!this.isStoppingConditionReached()) {
            System.out.println("Iter: " + this.iterations);
            this.shuffleGlobalBest();
            for (int i = 0; i < this.getSwarm().size(); ++i) {
                if (this.age[i] < this.maxAge) {
                    this.updateVelocity(i);
                    this.computeNewPositions(i);
                } else {
                    this.resetParticle(i);
                }
                this.repairBounds(i);
                this.problem.evaluate((Solution)this.swarm.get(i));
                this.updateReference(this.swarm.get(i));
                this.updateLocalBest(i);
            }
            this.updateGlobalBest();
            this.updateProgress();
        }
    }

    @Override
    public List<DoubleSolution> getResult() {
        return Arrays.asList(this.globalBest);
    }

    @Override
    public String getName() {
        return "dMOPSO";
    }

    @Override
    public String getDescription() {
        return "MOPSO with decomposition";
    }
}

