/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.gde3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractDifferentialEvolution;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.impl.selection.DifferentialEvolutionSelection;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.comparator.CrowdingDistanceComparator;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.solutionattribute.DensityEstimator;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.CrowdingDistance;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;

public class GDE3
extends AbstractDifferentialEvolution<List<DoubleSolution>> {
    protected int maxEvaluations;
    protected int evaluations;
    protected Comparator<DoubleSolution> dominanceComparator;
    protected Ranking<DoubleSolution> ranking;
    protected DensityEstimator<DoubleSolution> crowdingDistance;
    protected SolutionListEvaluator<DoubleSolution> evaluator;

    public GDE3(DoubleProblem problem, int populationSize, int maxEvaluations, DifferentialEvolutionSelection selection, DifferentialEvolutionCrossover crossover, SolutionListEvaluator<DoubleSolution> evaluator) {
        this.setProblem(problem);
        this.setMaxPopulationSize(populationSize);
        this.maxEvaluations = maxEvaluations;
        this.crossoverOperator = crossover;
        this.selectionOperator = selection;
        this.dominanceComparator = new DominanceComparator<DoubleSolution>();
        this.ranking = new DominanceRanking<DoubleSolution>();
        this.crowdingDistance = new CrowdingDistance<DoubleSolution>();
        this.evaluator = evaluator;
    }

    @Override
    protected void initProgress() {
        this.evaluations = this.getMaxPopulationSize();
    }

    @Override
    protected void updateProgress() {
        this.evaluations += this.getMaxPopulationSize();
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    @Override
    protected List<DoubleSolution> createInitialPopulation() {
        ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(this.getMaxPopulationSize());
        for (int i = 0; i < this.getMaxPopulationSize(); ++i) {
            DoubleSolution newIndividual = (DoubleSolution)this.getProblem().createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    @Override
    protected List<DoubleSolution> evaluatePopulation(List<DoubleSolution> population) {
        return this.evaluator.evaluate(population, this.getProblem());
    }

    @Override
    protected List<DoubleSolution> selection(List<DoubleSolution> population) {
        LinkedList<DoubleSolution> matingPopulation = new LinkedList<DoubleSolution>();
        for (int i = 0; i < this.getMaxPopulationSize(); ++i) {
            this.selectionOperator.setIndex(i);
            List<DoubleSolution> parents = this.selectionOperator.execute(population);
            matingPopulation.addAll(parents);
        }
        return matingPopulation;
    }

    @Override
    protected List<DoubleSolution> reproduction(List<DoubleSolution> matingPopulation) {
        ArrayList<DoubleSolution> offspringPopulation = new ArrayList<DoubleSolution>();
        for (int i = 0; i < this.getMaxPopulationSize(); ++i) {
            this.crossoverOperator.setCurrentSolution((DoubleSolution)this.getPopulation().get(i));
            ArrayList<DoubleSolution> parents = new ArrayList<DoubleSolution>(3);
            for (int j = 0; j < 3; ++j) {
                parents.add(matingPopulation.get(0));
                matingPopulation.remove(0);
            }
            this.crossoverOperator.setCurrentSolution((DoubleSolution)this.getPopulation().get(i));
            List<DoubleSolution> children = this.crossoverOperator.execute((List<DoubleSolution>)parents);
            offspringPopulation.add(children.get(0));
        }
        return offspringPopulation;
    }

    @Override
    protected List<DoubleSolution> replacement(List<DoubleSolution> population, List<DoubleSolution> offspringPopulation) {
        ArrayList<DoubleSolution> tmpList = new ArrayList<DoubleSolution>();
        for (int i = 0; i < this.getMaxPopulationSize(); ++i) {
            DoubleSolution child = offspringPopulation.get(i);
            int result = this.dominanceComparator.compare(population.get(i), child);
            if (result == -1) {
                tmpList.add(population.get(i));
                continue;
            }
            if (result == 1) {
                tmpList.add(child);
                continue;
            }
            tmpList.add(child);
            tmpList.add(population.get(i));
        }
        Ranking<DoubleSolution> ranking = this.computeRanking(tmpList);
        return this.crowdingDistanceSelection(ranking);
    }

    @Override
    public List<DoubleSolution> getResult() {
        return this.getNonDominatedSolutions(this.getPopulation());
    }

    protected Ranking<DoubleSolution> computeRanking(List<DoubleSolution> solutionList) {
        DominanceRanking<DoubleSolution> ranking = new DominanceRanking<DoubleSolution>();
        ranking.computeRanking(solutionList);
        return ranking;
    }

    protected List<DoubleSolution> crowdingDistanceSelection(Ranking<DoubleSolution> ranking) {
        CrowdingDistance<DoubleSolution> crowdingDistance = new CrowdingDistance<DoubleSolution>();
        ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(this.getMaxPopulationSize());
        int rankingIndex = 0;
        while (this.populationIsNotFull(population)) {
            if (this.subfrontFillsIntoThePopulation(ranking, rankingIndex, population)) {
                this.addRankedSolutionsToPopulation(ranking, rankingIndex, population);
                ++rankingIndex;
                continue;
            }
            crowdingDistance.computeDensityEstimator(ranking.getSubfront(rankingIndex));
            this.addLastRankedSolutionsToPopulation(ranking, rankingIndex, population);
        }
        return population;
    }

    protected boolean populationIsNotFull(List<DoubleSolution> population) {
        return population.size() < this.getMaxPopulationSize();
    }

    protected boolean subfrontFillsIntoThePopulation(Ranking<DoubleSolution> ranking, int rank, List<DoubleSolution> population) {
        return ranking.getSubfront(rank).size() < this.getMaxPopulationSize() - population.size();
    }

    protected void addRankedSolutionsToPopulation(Ranking<DoubleSolution> ranking, int rank, List<DoubleSolution> population) {
        List<DoubleSolution> front = ranking.getSubfront(rank);
        for (DoubleSolution solution : front) {
            population.add(solution);
        }
    }

    protected void addLastRankedSolutionsToPopulation(Ranking<DoubleSolution> ranking, int rank, List<DoubleSolution> population) {
        List<DoubleSolution> currentRankedFront = ranking.getSubfront(rank);
        Collections.sort(currentRankedFront, new CrowdingDistanceComparator());
        int i = 0;
        while (population.size() < this.getMaxPopulationSize()) {
            population.add(currentRankedFront.get(i));
            ++i;
        }
    }

    protected List<DoubleSolution> getNonDominatedSolutions(List<DoubleSolution> solutionList) {
        return SolutionListUtils.getNondominatedSolutions(solutionList);
    }

    @Override
    public String getName() {
        return "GDE3";
    }

    @Override
    public String getDescription() {
        return "Generalized Differential Evolution version 3";
    }
}

