/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.gwasfga.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.AbstractUtilityFunctionsSet;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.GenericSolutionAttribute;

public class GWASFGARanking<S extends Solution<?>>
extends GenericSolutionAttribute<S, Integer>
implements Ranking<S> {
    private AbstractUtilityFunctionsSet<S> utilityFunctionsUtopia;
    private AbstractUtilityFunctionsSet<S> utilityFunctionsNadir;
    private List<List<S>> rankedSubpopulations;
    private int numberOfRanks = 0;

    public GWASFGARanking(AbstractUtilityFunctionsSet<S> utilityFunctionsUtopia, AbstractUtilityFunctionsSet<S> utilityFunctionsNadir) {
        this.utilityFunctionsUtopia = utilityFunctionsUtopia;
        this.utilityFunctionsNadir = utilityFunctionsNadir;
    }

    @Override
    public Ranking<S> computeRanking(List<S> population) {
        this.numberOfRanks = (population.size() + 1) / (this.utilityFunctionsUtopia.getSize() + this.utilityFunctionsNadir.getSize());
        this.rankedSubpopulations = new ArrayList<List<S>>(this.numberOfRanks);
        for (int i = 0; i < this.numberOfRanks; ++i) {
            this.rankedSubpopulations.add(new ArrayList());
        }
        LinkedList<S> temporalList = new LinkedList<S>();
        temporalList.addAll(population);
        for (int idx = 0; idx < this.numberOfRanks; ++idx) {
            Solution solutionToInsert;
            double value;
            double minimumValue;
            int toRemoveIdx;
            int weigth;
            for (weigth = 0; weigth < this.utilityFunctionsUtopia.getSize(); ++weigth) {
                toRemoveIdx = 0;
                minimumValue = this.utilityFunctionsUtopia.evaluate((Solution)temporalList.get(0), weigth);
                for (int solutionIdx = 1; solutionIdx < temporalList.size(); ++solutionIdx) {
                    value = this.utilityFunctionsUtopia.evaluate((Solution)temporalList.get(solutionIdx), weigth);
                    if (!(value < minimumValue)) continue;
                    minimumValue = value;
                    toRemoveIdx = solutionIdx;
                }
                solutionToInsert = (Solution)temporalList.remove(toRemoveIdx);
                this.setAttribute(solutionToInsert, idx);
                this.rankedSubpopulations.get(idx).add(solutionToInsert);
            }
            for (weigth = 0; weigth < this.utilityFunctionsNadir.getSize(); ++weigth) {
                toRemoveIdx = 0;
                minimumValue = this.utilityFunctionsNadir.evaluate((Solution)temporalList.get(0), weigth);
                for (int solutionIdx = 1; solutionIdx < temporalList.size(); ++solutionIdx) {
                    value = this.utilityFunctionsNadir.evaluate((Solution)temporalList.get(solutionIdx), weigth);
                    if (!(value < minimumValue)) continue;
                    minimumValue = value;
                    toRemoveIdx = solutionIdx;
                }
                solutionToInsert = (Solution)temporalList.remove(toRemoveIdx);
                this.setAttribute(solutionToInsert, idx);
                this.rankedSubpopulations.get(idx).add(solutionToInsert);
            }
        }
        return this;
    }

    @Override
    public List<S> getSubfront(int rank) {
        return this.rankedSubpopulations.get(rank);
    }

    @Override
    public int getNumberOfSubfronts() {
        return this.rankedSubpopulations.size();
    }
}

