/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.mocell;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractGeneticAlgorithm;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.neighborhood.Neighborhood;
import org.uma.jmetal.util.solutionattribute.impl.CrowdingDistance;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;
import org.uma.jmetal.util.solutionattribute.impl.LocationAttribute;

public class MOCell<S extends Solution<?>>
extends AbstractGeneticAlgorithm<S, List<S>> {
    protected int evaluations;
    protected int maxEvaluations;
    protected final SolutionListEvaluator<S> evaluator;
    private Neighborhood<S> neighborhood;
    private int currentIndividual;
    private List<S> currentNeighbors;
    private BoundedArchive<S> archive;
    private Comparator<S> dominanceComparator;
    private LocationAttribute<S> location;

    public MOCell(Problem<S> problem, int maxEvaluations, int populationSize, BoundedArchive<S> archive, Neighborhood<S> neighborhood, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, SolutionListEvaluator<S> evaluator) {
        super(problem);
        this.maxEvaluations = maxEvaluations;
        this.setMaxPopulationSize(populationSize);
        this.archive = archive;
        this.neighborhood = neighborhood;
        this.crossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
        this.selectionOperator = selectionOperator;
        this.dominanceComparator = new DominanceComparator();
        this.evaluator = evaluator;
    }

    @Override
    protected void initProgress() {
        this.evaluations = 0;
        this.currentIndividual = 0;
    }

    @Override
    protected void updateProgress() {
        ++this.evaluations;
        this.currentIndividual = (this.currentIndividual + 1) % this.getMaxPopulationSize();
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.evaluations == this.maxEvaluations;
    }

    @Override
    protected List<S> createInitialPopulation() {
        ArrayList population = new ArrayList(this.getMaxPopulationSize());
        for (int i = 0; i < this.getMaxPopulationSize(); ++i) {
            Object newIndividual = this.getProblem().createSolution();
            population.add(newIndividual);
        }
        this.location = new LocationAttribute(population);
        return population;
    }

    @Override
    protected List<S> evaluatePopulation(List<S> population) {
        population = this.evaluator.evaluate(population, this.getProblem());
        for (Solution solution : population) {
            this.archive.add(solution.copy());
        }
        return population;
    }

    @Override
    protected List<S> selection(List<S> population) {
        ArrayList parents = new ArrayList(2);
        this.currentNeighbors = this.neighborhood.getNeighbors(population, this.currentIndividual);
        this.currentNeighbors.add(population.get(this.currentIndividual));
        parents.add(this.selectionOperator.execute(this.currentNeighbors));
        if (this.archive.size() > 0) {
            parents.add(this.selectionOperator.execute(this.archive.getSolutionList()));
        } else {
            parents.add(this.selectionOperator.execute(this.currentNeighbors));
        }
        return parents;
    }

    @Override
    protected List<S> reproduction(List<S> population) {
        ArrayList result = new ArrayList(1);
        List offspring = (List)this.crossoverOperator.execute(population);
        this.mutationOperator.execute(offspring.get(0));
        result.add(offspring.get(0));
        return result;
    }

    @Override
    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        int flag = this.dominanceComparator.compare(population.get(this.currentIndividual), offspringPopulation.get(0));
        if (flag == 1) {
            this.insertNewIndividualWhenDominates(population, offspringPopulation);
        } else if (flag == 0) {
            this.insertNewIndividualWhenNonDominated(population, offspringPopulation);
        }
        return population;
    }

    @Override
    public List<S> getResult() {
        return this.archive.getSolutionList();
    }

    private void insertNewIndividualWhenDominates(List<S> population, List<S> offspringPopulation) {
        this.location.setAttribute((Solution)offspringPopulation.get(0), this.location.getAttribute((Solution)population.get(this.currentIndividual)));
        population.set((Integer)this.location.getAttribute((Solution)offspringPopulation.get(0)), offspringPopulation.get(0));
        this.archive.add((Solution)offspringPopulation.get(0));
    }

    private void insertNewIndividualWhenNonDominated(List<S> population, List<S> offspringPopulation) {
        this.currentNeighbors.add(offspringPopulation.get(0));
        this.location.setAttribute((Solution)offspringPopulation.get(0), -1);
        DominanceRanking<S> rank = new DominanceRanking<S>();
        rank.computeRanking(this.currentNeighbors);
        CrowdingDistance crowdingDistance = new CrowdingDistance();
        for (int j = 0; j < rank.getNumberOfSubfronts(); ++j) {
            crowdingDistance.computeDensityEstimator(rank.getSubfront(j));
        }
        Collections.sort(this.currentNeighbors, new RankingAndCrowdingDistanceComparator());
        Solution worst = (Solution)this.currentNeighbors.get(this.currentNeighbors.size() - 1);
        if ((Integer)this.location.getAttribute(worst) == -1) {
            this.archive.add((Solution)offspringPopulation.get(0));
        } else {
            this.location.setAttribute((Solution)offspringPopulation.get(0), this.location.getAttribute(worst));
            population.set((Integer)this.location.getAttribute((Solution)offspringPopulation.get(0)), offspringPopulation.get(0));
            this.archive.add((Solution)offspringPopulation.get(0));
        }
    }

    @Override
    public String getName() {
        return "MOCell";
    }

    @Override
    public String getDescription() {
        return "Multi-Objective Cellular evolutionry algorithm";
    }
}

