/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.moead;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.moead.AbstractMOEAD;
import org.uma.jmetal.algorithm.multiobjective.moead.util.MOEADUtils;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.impl.crossover.DifferentialEvolutionCrossover;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class MOEADSTM
extends AbstractMOEAD<DoubleSolution> {
    private DifferentialEvolutionCrossover differentialEvolutionCrossover;
    private DoubleSolution[] savedValues;
    private double[] utility;
    private int[] frequency;
    JMetalRandom randomGenerator;

    public MOEADSTM(Problem<DoubleSolution> problem, int populationSize, int resultPopulationSize, int maxEvaluations, MutationOperator<DoubleSolution> mutation, CrossoverOperator<DoubleSolution> crossover, AbstractMOEAD.FunctionType functionType, String dataDirectory, double neighborhoodSelectionProbability, int maximumNumberOfReplacedSolutions, int neighborSize) {
        super(problem, populationSize, resultPopulationSize, maxEvaluations, crossover, mutation, functionType, dataDirectory, neighborhoodSelectionProbability, maximumNumberOfReplacedSolutions, neighborSize);
        this.differentialEvolutionCrossover = (DifferentialEvolutionCrossover)this.crossoverOperator;
        this.savedValues = new DoubleSolution[populationSize];
        this.utility = new double[populationSize];
        this.frequency = new int[populationSize];
        for (int i = 0; i < this.utility.length; ++i) {
            this.utility[i] = 1.0;
            this.frequency[i] = 0;
        }
        this.randomGenerator = JMetalRandom.getInstance();
    }

    @Override
    public void run() {
        this.initializePopulation();
        this.initializeUniformWeight();
        this.initializeNeighborhood();
        this.initializeIdealPoint();
        this.initializeNadirPoint();
        int generation = 0;
        this.evaluations = this.populationSize;
        do {
            int[] permutation = new int[this.populationSize];
            MOEADUtils.randomPermutation(permutation, this.populationSize);
            this.offspringPopulation.clear();
            for (int i = 0; i < this.populationSize; ++i) {
                int subProblemId;
                int n = subProblemId = permutation[i];
                this.frequency[n] = this.frequency[n] + 1;
                AbstractMOEAD.NeighborType neighborType = this.chooseNeighborType();
                List<DoubleSolution> parents = this.parentSelection(subProblemId, neighborType);
                this.differentialEvolutionCrossover.setCurrentSolution((DoubleSolution)this.population.get(subProblemId));
                List<DoubleSolution> children = this.differentialEvolutionCrossover.execute(parents);
                DoubleSolution child = children.get(0);
                this.mutationOperator.execute(child);
                this.problem.evaluate(child);
                ++this.evaluations;
                this.updateIdealPoint(child);
                this.updateNadirPoint(child);
                this.updateNeighborhood(child, subProblemId, neighborType);
                this.offspringPopulation.add(child);
            }
            this.jointPopulation.clear();
            this.jointPopulation.addAll(this.population);
            this.jointPopulation.addAll(this.offspringPopulation);
            this.stmSelection();
            if (++generation % 30 != 0) continue;
            this.utilityFunction();
        } while (this.evaluations < this.maxEvaluations);
    }

    protected void initializePopulation() {
        this.population = new ArrayList(this.populationSize);
        this.offspringPopulation = new ArrayList(this.populationSize);
        this.jointPopulation = new ArrayList(this.populationSize);
        for (int i = 0; i < this.populationSize; ++i) {
            DoubleSolution newSolution = (DoubleSolution)this.problem.createSolution();
            this.problem.evaluate(newSolution);
            this.population.add(newSolution);
            this.savedValues[i] = (DoubleSolution)newSolution.copy();
        }
    }

    @Override
    public List<DoubleSolution> getResult() {
        return this.population;
    }

    public void utilityFunction() throws JMetalException {
        for (int n = 0; n < this.populationSize; ++n) {
            double uti;
            double f1 = this.fitnessFunction((Solution)this.population.get(n), this.lambda[n]);
            double f2 = this.fitnessFunction(this.savedValues[n], this.lambda[n]);
            double delta = f2 - f1;
            this.utility[n] = delta > 0.001 ? 1.0 : ((uti = (0.95 + 0.05 * delta / 0.001) * this.utility[n]) < 1.0 ? uti : 1.0);
            this.savedValues[n] = (DoubleSolution)((DoubleSolution)this.population.get(n)).copy();
        }
    }

    public List<Integer> tourSelection(int depth) {
        ArrayList<Integer> selected = new ArrayList<Integer>();
        ArrayList<Integer> candidate = new ArrayList<Integer>();
        for (int k = 0; k < this.problem.getNumberOfObjectives(); ++k) {
            selected.add(k);
        }
        for (int n = this.problem.getNumberOfObjectives(); n < this.populationSize; ++n) {
            candidate.add(n);
        }
        while (selected.size() < (int)((double)this.populationSize / 5.0)) {
            int best_idd = (int)(this.randomGenerator.nextDouble() * (double)candidate.size());
            int best_sub = (Integer)candidate.get(best_idd);
            for (int i = 1; i < depth; ++i) {
                int i2 = (int)(this.randomGenerator.nextDouble() * (double)candidate.size());
                int s2 = (Integer)candidate.get(i2);
                if (!(this.utility[s2] > this.utility[best_sub])) continue;
                best_idd = i2;
                best_sub = s2;
            }
            selected.add(best_sub);
            candidate.remove(best_idd);
        }
        return selected;
    }

    public void stmSelection() {
        int j;
        int i;
        int[] idx = new int[this.populationSize];
        double[] nicheCount = new double[this.populationSize];
        int[][] solPref = new int[this.jointPopulation.size()][];
        double[][] solMatrix = new double[this.jointPopulation.size()][];
        double[][] distMatrix = new double[this.jointPopulation.size()][];
        double[][] fitnessMatrix = new double[this.jointPopulation.size()][];
        for (int i2 = 0; i2 < this.jointPopulation.size(); ++i2) {
            solPref[i2] = new int[this.populationSize];
            solMatrix[i2] = new double[this.populationSize];
            distMatrix[i2] = new double[this.populationSize];
            fitnessMatrix[i2] = new double[this.populationSize];
        }
        int[][] subpPref = new int[this.populationSize][];
        double[][] subpMatrix = new double[this.populationSize][];
        for (i = 0; i < this.populationSize; ++i) {
            subpPref[i] = new int[this.jointPopulation.size()];
            subpMatrix[i] = new double[this.jointPopulation.size()];
        }
        for (i = 0; i < this.jointPopulation.size(); ++i) {
            int minIndex = 0;
            for (int j2 = 0; j2 < this.populationSize; ++j2) {
                fitnessMatrix[i][j2] = this.fitnessFunction((Solution)this.jointPopulation.get(i), this.lambda[j2]);
                distMatrix[i][j2] = this.calculateDistance2((DoubleSolution)this.jointPopulation.get(i), this.lambda[j2]);
                if (!(distMatrix[i][j2] < distMatrix[i][minIndex])) continue;
                minIndex = j2;
            }
            nicheCount[minIndex] = nicheCount[minIndex] + 1.0;
        }
        for (i = 0; i < this.jointPopulation.size(); ++i) {
            for (j = 0; j < this.populationSize; ++j) {
                subpMatrix[j][i] = this.fitnessFunction((Solution)this.jointPopulation.get(i), this.lambda[j]);
                solMatrix[i][j] = distMatrix[i][j] + nicheCount[j];
            }
        }
        for (i = 0; i < this.populationSize; ++i) {
            for (j = 0; j < this.jointPopulation.size(); ++j) {
                subpPref[i][j] = j;
            }
            MOEADUtils.quickSort(subpMatrix[i], subpPref[i], 0, this.jointPopulation.size() - 1);
        }
        for (i = 0; i < this.jointPopulation.size(); ++i) {
            for (j = 0; j < this.populationSize; ++j) {
                solPref[i][j] = j;
            }
            MOEADUtils.quickSort(solMatrix[i], solPref[i], 0, this.populationSize - 1);
        }
        idx = this.stableMatching(subpPref, solPref, this.populationSize, this.jointPopulation.size());
        this.population.clear();
        for (i = 0; i < this.populationSize; ++i) {
            this.population.add(i, this.jointPopulation.get(idx[i]));
        }
    }

    public int[] stableMatching(int[][] manPref, int[][] womanPref, int menSize, int womenSize) {
        int[] statusMan = new int[menSize];
        int[] statusWoman = new int[womenSize];
        int NOT_ENGAGED = -1;
        for (int i = 0; i < womenSize; ++i) {
            statusWoman[i] = -1;
        }
        LinkedList<Integer> freeMen = new LinkedList<Integer>();
        for (int i = 0; i < menSize; ++i) {
            freeMen.add(i);
        }
        int[] next = new int[womenSize];
        while (!freeMen.isEmpty()) {
            int m = (Integer)freeMen.remove();
            int w = manPref[m][next[m]];
            int n = m;
            next[n] = next[n] + 1;
            if (statusWoman[w] == -1) {
                statusMan[m] = w;
                statusWoman[w] = m;
                continue;
            }
            int m1 = statusWoman[w];
            if (this.prefers(m, m1, womanPref[w], menSize)) {
                statusMan[m] = w;
                statusWoman[w] = m;
                freeMen.add(m1);
                continue;
            }
            freeMen.add(m);
        }
        return statusMan;
    }

    public boolean prefers(int x, int y, int[] womanPref, int size) {
        for (int i = 0; i < size; ++i) {
            int pref = womanPref[i];
            if (pref == x) {
                return true;
            }
            if (pref != y) continue;
            return false;
        }
        System.out.println("Error in womanPref list!");
        return false;
    }

    public double calculateDistance(DoubleSolution individual, double[] lambda) {
        int i;
        double[] vecInd = new double[this.problem.getNumberOfObjectives()];
        double[] vecProj = new double[this.problem.getNumberOfObjectives()];
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            vecInd[i] = (individual.getObjective(i) - this.idealPoint[i]) / (this.nadirPoint[i] - this.idealPoint[i]);
        }
        double scale = this.innerproduct(vecInd, lambda) / this.innerproduct(lambda, lambda);
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            vecProj[i] = vecInd[i] - scale * lambda[i];
        }
        double distance = this.norm_vector(vecProj);
        return distance;
    }

    public double calculateDistance2(DoubleSolution individual, double[] lambda) {
        int i;
        double distanceSum = 0.0;
        double[] vecInd = new double[this.problem.getNumberOfObjectives()];
        double[] normalizedObj = new double[this.problem.getNumberOfObjectives()];
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            distanceSum += individual.getObjective(i);
        }
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            normalizedObj[i] = individual.getObjective(i) / distanceSum;
        }
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            vecInd[i] = normalizedObj[i] - lambda[i];
        }
        double distance = this.norm_vector(vecInd);
        return distance;
    }

    public double norm_vector(double[] z) {
        double sum = 0.0;
        for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            sum += z[i] * z[i];
        }
        return Math.sqrt(sum);
    }

    public double innerproduct(double[] vec1, double[] vec2) {
        double sum = 0.0;
        for (int i = 0; i < vec1.length; ++i) {
            sum += vec1[i] * vec2[i];
        }
        return sum;
    }

    @Override
    public String getName() {
        return "MOEADSTM";
    }

    @Override
    public String getDescription() {
        return "Multi-Objective Evolutionary Algorithm based on Decomposition. Version with Stable Matching Model";
    }
}

