/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.mombi;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractGeneticAlgorithm;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public abstract class AbstractMOMBI<S extends Solution<?>>
extends AbstractGeneticAlgorithm<S, List<S>> {
    private final int maxIterations;
    private int iterations = 0;
    private final SolutionListEvaluator<S> evaluator;
    private final List<Double> referencePoint;
    private final List<Double> nadirPoint;

    public AbstractMOMBI(Problem<S> problem, int maxIterations, CrossoverOperator<S> crossover, MutationOperator<S> mutation, SelectionOperator<List<S>, S> selection, SolutionListEvaluator<S> evaluator) {
        super(problem);
        this.maxIterations = maxIterations;
        this.crossoverOperator = crossover;
        this.mutationOperator = mutation;
        this.selectionOperator = selection;
        this.evaluator = evaluator;
        this.nadirPoint = new ArrayList<Double>(this.getProblem().getNumberOfObjectives());
        this.initializeNadirPoint(this.getProblem().getNumberOfObjectives());
        this.referencePoint = new ArrayList<Double>(this.getProblem().getNumberOfObjectives());
        this.initializeReferencePoint(this.getProblem().getNumberOfObjectives());
    }

    @Override
    protected void initProgress() {
        this.iterations = 1;
    }

    @Override
    protected void updateProgress() {
        ++this.iterations;
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.iterations >= this.maxIterations;
    }

    @Override
    protected List<S> evaluatePopulation(List<S> population) {
        population = this.evaluator.evaluate(population, this.getProblem());
        return population;
    }

    @Override
    protected List<S> selection(List<S> population) {
        ArrayList<Solution> matingPopulation = new ArrayList<Solution>(population.size());
        for (int i = 0; i < this.getMaxPopulationSize(); ++i) {
            Solution solution = (Solution)this.selectionOperator.execute(population);
            matingPopulation.add(solution);
        }
        return matingPopulation;
    }

    @Override
    protected List<S> reproduction(List<S> population) {
        ArrayList offspringPopulation = new ArrayList(this.getMaxPopulationSize());
        for (int i = 0; i < this.getMaxPopulationSize(); i += 2) {
            ArrayList<S> parents = new ArrayList<S>(2);
            int parent1Index = JMetalRandom.getInstance().nextInt(0, this.getMaxPopulationSize() - 1);
            int parent2Index = JMetalRandom.getInstance().nextInt(0, this.getMaxPopulationSize() - 1);
            while (parent1Index == parent2Index) {
                parent2Index = JMetalRandom.getInstance().nextInt(0, this.getMaxPopulationSize() - 1);
            }
            parents.add(population.get(parent1Index));
            parents.add(population.get(parent2Index));
            List offspring = (List)this.crossoverOperator.execute(parents);
            this.mutationOperator.execute(offspring.get(0));
            this.mutationOperator.execute(offspring.get(1));
            offspringPopulation.add(offspring.get(0));
            offspringPopulation.add(offspring.get(1));
        }
        return offspringPopulation;
    }

    @Override
    public List<S> getResult() {
        this.setPopulation(this.evaluator.evaluate(this.getPopulation(), this.getProblem()));
        return this.getPopulation();
    }

    @Override
    public void run() {
        this.setPopulation(this.createInitialPopulation());
        this.evaluatePopulation(this.getPopulation());
        this.initProgress();
        this.specificMOEAComputations();
        while (!this.isStoppingConditionReached()) {
            List matingPopulation = this.selection(this.getPopulation());
            List offspringPopulation = this.reproduction(matingPopulation);
            offspringPopulation = this.evaluatePopulation(offspringPopulation);
            this.setPopulation(this.replacement(this.getPopulation(), offspringPopulation));
            this.updateProgress();
            this.specificMOEAComputations();
        }
    }

    public abstract void specificMOEAComputations();

    public List<Double> getReferencePoint() {
        return this.referencePoint;
    }

    public List<Double> getNadirPoint() {
        return this.nadirPoint;
    }

    private void initializeReferencePoint(int size) {
        for (int i = 0; i < size; ++i) {
            this.getReferencePoint().add(Double.POSITIVE_INFINITY);
        }
    }

    private void initializeNadirPoint(int size) {
        for (int i = 0; i < size; ++i) {
            this.getNadirPoint().add(Double.NEGATIVE_INFINITY);
        }
    }

    protected void updateReferencePoint(S s) {
        for (int i = 0; i < s.getNumberOfObjectives(); ++i) {
            this.getReferencePoint().set(i, Math.min(this.getReferencePoint().get(i), s.getObjective(i)));
        }
    }

    private void updateNadirPoint(S s) {
        for (int i = 0; i < s.getNumberOfObjectives(); ++i) {
            this.getNadirPoint().set(i, Math.max(this.getNadirPoint().get(i), s.getObjective(i)));
        }
    }

    public void updateReferencePoint(List<S> population) {
        for (Solution solution : population) {
            this.updateReferencePoint(solution);
        }
    }

    public void updateNadirPoint(List<S> population) {
        for (Solution solution : population) {
            this.updateNadirPoint(solution);
        }
    }

    protected boolean populationIsNotFull(List<S> population) {
        return population.size() < this.getMaxPopulationSize();
    }

    protected void setReferencePointValue(Double value, int index) {
        if (index < 0 || index >= this.referencePoint.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.referencePoint.set(index, value);
    }
}

