/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.mombi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.mombi.AbstractMOMBI;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.AbstractUtilityFunctionsSet;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.R2Ranking;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.R2RankingAttribute;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.R2SolutionData;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.TchebycheffUtilityFunctionsSet;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;

public class MOMBI<S extends Solution<?>>
extends AbstractMOMBI<S> {
    private final AbstractUtilityFunctionsSet<S> utilityFunctions;

    public MOMBI(Problem<S> problem, int maxIterations, CrossoverOperator<S> crossover, MutationOperator<S> mutation, SelectionOperator<List<S>, S> selection, SolutionListEvaluator<S> evaluator, String pathWeights) {
        super(problem, maxIterations, crossover, mutation, selection, evaluator);
        this.utilityFunctions = this.createUtilityFunction(pathWeights);
    }

    public AbstractUtilityFunctionsSet<S> createUtilityFunction(String pathWeights) {
        return new TchebycheffUtilityFunctionsSet(pathWeights, this.getReferencePoint());
    }

    @Override
    public int getMaxPopulationSize() {
        return this.utilityFunctions.getSize();
    }

    @Override
    public void specificMOEAComputations() {
        this.updateNadirPoint(this.getPopulation());
        this.updateReferencePoint(this.getPopulation());
    }

    @Override
    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        ArrayList<S> jointPopulation = new ArrayList<S>();
        jointPopulation.addAll(population);
        jointPopulation.addAll(offspringPopulation);
        R2Ranking ranking = this.computeRanking(jointPopulation);
        return this.selectBest(ranking);
    }

    protected R2Ranking<S> computeRanking(List<S> solutionList) {
        R2Ranking<S> ranking = new R2Ranking<S>(this.utilityFunctions);
        ranking.computeRanking(solutionList);
        return ranking;
    }

    protected void addRankedSolutionsToPopulation(R2Ranking<S> ranking, int index, List<S> population) {
        for (Solution solution : ranking.getSubfront(index)) {
            population.add(solution);
        }
    }

    protected void addLastRankedSolutionsToPopulation(R2Ranking<S> ranking, int index, List<S> population) {
        List<S> front = ranking.getSubfront(index);
        Collections.sort(front, new Comparator<S>(){

            @Override
            public int compare(S arg0, S arg1) {
                R2RankingAttribute attribute = new R2RankingAttribute();
                R2SolutionData dataFirst = (R2SolutionData)attribute.getAttribute(arg0);
                R2SolutionData dataSecond = (R2SolutionData)attribute.getAttribute(arg1);
                if (dataFirst.utility > dataSecond.utility) {
                    return -1;
                }
                if (dataFirst.utility < dataSecond.utility) {
                    return 1;
                }
                return 0;
            }
        });
        int remain = this.getMaxPopulationSize() - population.size();
        for (Solution solution : front.subList(0, remain)) {
            population.add(solution);
        }
    }

    protected List<S> selectBest(R2Ranking<S> ranking) {
        ArrayList population = new ArrayList(this.getMaxPopulationSize());
        int rankingIndex = 0;
        while (this.populationIsNotFull(population)) {
            if (this.subfrontFillsIntoThePopulation(ranking, rankingIndex, population)) {
                this.addRankedSolutionsToPopulation(ranking, rankingIndex, population);
                ++rankingIndex;
                continue;
            }
            this.addLastRankedSolutionsToPopulation(ranking, rankingIndex, population);
        }
        return population;
    }

    private boolean subfrontFillsIntoThePopulation(R2Ranking<S> ranking, int index, List<S> population) {
        return population.size() + ranking.getSubfront(index).size() < this.getMaxPopulationSize();
    }

    protected AbstractUtilityFunctionsSet<S> getUtilityFunctions() {
        return this.utilityFunctions;
    }

    @Override
    public String getName() {
        return "MOMBI";
    }

    @Override
    public String getDescription() {
        return "Many-Objective Metaheuristic Based on the R2 Indicator";
    }
}

