/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.mombi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.AbstractUtilityFunctionsSet;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.R2RankingAttribute;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.R2SolutionData;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.solutionattribute.impl.GenericSolutionAttribute;

public class R2Ranking<S extends Solution<?>>
extends GenericSolutionAttribute<S, R2SolutionData> {
    private AbstractUtilityFunctionsSet<S> utilityFunctions;
    private List<List<S>> rankedSubpopulations;
    private int numberOfRanks = 0;
    private R2RankingAttribute<S> attribute = new R2RankingAttribute();

    public R2Ranking(AbstractUtilityFunctionsSet<S> utilityFunctions) {
        this.utilityFunctions = utilityFunctions;
    }

    public R2Ranking<S> computeRanking(List<S> population) {
        for (Solution solution : population) {
            solution.setAttribute(this.getAttributeID(), new R2SolutionData());
        }
        for (int i = 0; i < this.utilityFunctions.getSize(); ++i) {
            Object solution2;
            for (Object solution2 : population) {
                Object solutionData = this.getAttribute((Solution)solution2);
                ((R2SolutionData)solutionData).alpha = this.utilityFunctions.evaluate(solution2, i);
                if (!(((R2SolutionData)solutionData).alpha < ((R2SolutionData)solutionData).utility)) continue;
                ((R2SolutionData)solutionData).utility = ((R2SolutionData)solutionData).alpha;
            }
            Collections.sort(population, new Comparator<S>(){

                @Override
                public int compare(S o1, S o2) {
                    R2RankingAttribute attribute = new R2RankingAttribute();
                    R2SolutionData data1 = (R2SolutionData)attribute.getAttribute(o1);
                    R2SolutionData data2 = (R2SolutionData)attribute.getAttribute(o2);
                    if (data1.alpha < data2.alpha) {
                        return -1;
                    }
                    if (data1.alpha > data2.alpha) {
                        return 1;
                    }
                    return 0;
                }
            });
            int rank = 1;
            solution2 = population.iterator();
            while (solution2.hasNext()) {
                Solution p = (Solution)solution2.next();
                Object r2Data = this.getAttribute(p);
                if (rank < ((R2SolutionData)r2Data).rank) {
                    ((R2SolutionData)r2Data).rank = rank;
                    this.numberOfRanks = Math.max(this.numberOfRanks, rank);
                }
                ++rank;
            }
        }
        TreeMap fronts = new TreeMap();
        for (Object solution2 : population) {
            Object r2Data = this.getAttribute((Solution)solution2);
            if (fronts.get(((R2SolutionData)r2Data).rank) == null) {
                fronts.put(((R2SolutionData)r2Data).rank, new LinkedList());
            }
            ((List)fronts.get(((R2SolutionData)r2Data).rank)).add(solution2);
        }
        this.rankedSubpopulations = new ArrayList<List<S>>(fronts.size());
        Iterator iterator = fronts.keySet().iterator();
        while (iterator.hasNext()) {
            this.rankedSubpopulations.add((List<S>)fronts.get(iterator.next()));
        }
        return this;
    }

    public List<S> getSubfront(int rank) {
        return this.rankedSubpopulations.get(rank);
    }

    public int getNumberOfSubfronts() {
        return this.rankedSubpopulations.size();
    }

    @Override
    public void setAttribute(S solution, R2SolutionData value) {
        this.attribute.setAttribute(solution, value);
    }

    @Override
    public R2SolutionData getAttribute(S solution) {
        return (R2SolutionData)this.attribute.getAttribute(solution);
    }

    @Override
    public Object getAttributeID() {
        return this.attribute.getAttributeID();
    }

    public AbstractUtilityFunctionsSet<S> getUtilityFunctions() {
        return this.utilityFunctions;
    }
}

