/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.nsgaii;

import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.measure.Measurable;
import org.uma.jmetal.measure.MeasureManager;
import org.uma.jmetal.measure.impl.BasicMeasure;
import org.uma.jmetal.measure.impl.CountingMeasure;
import org.uma.jmetal.measure.impl.DurationMeasure;
import org.uma.jmetal.measure.impl.SimpleMeasureManager;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.solutionattribute.Ranking;

public class NSGAIIMeasures<S extends Solution<?>>
extends NSGAII<S>
implements Measurable {
    protected CountingMeasure evaluations;
    protected DurationMeasure durationMeasure;
    protected SimpleMeasureManager measureManager;
    protected BasicMeasure<List<S>> solutionListMeasure;
    protected BasicMeasure<Integer> numberOfNonDominatedSolutionsInPopulation;

    public NSGAIIMeasures(Problem<S> problem, int maxIterations, int populationSize, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, SolutionListEvaluator<S> evaluator) {
        super(problem, maxIterations, populationSize, crossoverOperator, mutationOperator, selectionOperator, evaluator);
        this.initMeasures();
    }

    @Override
    protected void initProgress() {
        this.evaluations.reset(this.getMaxPopulationSize());
    }

    @Override
    protected void updateProgress() {
        this.evaluations.increment(this.getMaxPopulationSize());
        this.solutionListMeasure.push(this.getPopulation());
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.evaluations.get() >= (long)this.maxEvaluations;
    }

    @Override
    public void run() {
        this.durationMeasure.reset();
        this.durationMeasure.start();
        super.run();
        this.durationMeasure.stop();
    }

    private void initMeasures() {
        this.durationMeasure = new DurationMeasure();
        this.evaluations = new CountingMeasure(0L);
        this.numberOfNonDominatedSolutionsInPopulation = new BasicMeasure();
        this.solutionListMeasure = new BasicMeasure();
        this.measureManager = new SimpleMeasureManager();
        this.measureManager.setPullMeasure("currentExecutionTime", this.durationMeasure);
        this.measureManager.setPullMeasure("currentEvaluation", this.evaluations);
        this.measureManager.setPullMeasure("numberOfNonDominatedSolutionsInPopulation", this.numberOfNonDominatedSolutionsInPopulation);
        this.measureManager.setPushMeasure("currentPopulation", this.solutionListMeasure);
        this.measureManager.setPushMeasure("currentEvaluation", this.evaluations);
    }

    @Override
    public MeasureManager getMeasureManager() {
        return this.measureManager;
    }

    @Override
    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        List<S> pop = super.replacement(population, offspringPopulation);
        Ranking<S> ranking = this.computeRanking(pop);
        this.numberOfNonDominatedSolutionsInPopulation.set(ranking.getSubfront(0).size());
        return pop;
    }

    public CountingMeasure getEvaluations() {
        return this.evaluations;
    }

    @Override
    public String getName() {
        return "NSGAIIM";
    }

    @Override
    public String getDescription() {
        return "Nondominated Sorting Genetic Algorithm version II. Version using measures";
    }
}

