/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.nsgaiii.util;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.nsgaiii.util.ReferencePoint;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.solutionattribute.SolutionAttribute;

public class EnvironmentalSelection<S extends Solution<?>>
implements SelectionOperator<List<S>, List<S>>,
SolutionAttribute<S, List<Double>> {
    private List<List<S>> fronts;
    private int solutionsToSelect;
    private List<ReferencePoint<S>> referencePoints;
    private int numberOfObjectives;

    public EnvironmentalSelection(Builder<S> builder) {
        this.fronts = builder.getFronts();
        this.solutionsToSelect = builder.getSolutionsToSelet();
        this.referencePoints = builder.getReferencePoints();
        this.numberOfObjectives = builder.getNumberOfObjectives();
    }

    public EnvironmentalSelection(List<List<S>> fronts, int solutionsToSelect, List<ReferencePoint<S>> referencePoints, int numberOfObjectives) {
        this.fronts = fronts;
        this.solutionsToSelect = solutionsToSelect;
        this.referencePoints = referencePoints;
        this.numberOfObjectives = numberOfObjectives;
    }

    public List<Double> translateObjectives(List<S> population) {
        ArrayList<Double> ideal_point = new ArrayList<Double>(this.numberOfObjectives);
        for (int f = 0; f < this.numberOfObjectives; ++f) {
            double minf = Double.MAX_VALUE;
            for (int i = 0; i < this.fronts.get(0).size(); ++i) {
                minf = Math.min(minf, ((Solution)this.fronts.get(0).get(i)).getObjective(f));
            }
            ideal_point.add(minf);
            for (List<S> list : this.fronts) {
                for (Solution s : list) {
                    if (f == 0) {
                        this.setAttribute((S)s, (List<Double>)new ArrayList<Double>());
                    }
                    this.getAttribute(s).add(s.getObjective(f) - minf);
                }
            }
        }
        return ideal_point;
    }

    private double ASF(S s, int index) {
        double max_ratio = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < s.getNumberOfObjectives(); ++i) {
            double weight = index == i ? 1.0 : 1.0E-6;
            max_ratio = Math.max(max_ratio, s.getObjective(i) / weight);
        }
        return max_ratio;
    }

    private List<S> findExtremePoints(List<S> population) {
        ArrayList<Solution> extremePoints = new ArrayList<Solution>();
        Solution min_indv = null;
        for (int f = 0; f < this.numberOfObjectives; ++f) {
            double min_ASF = Double.MAX_VALUE;
            for (Solution s : this.fronts.get(0)) {
                double asf = this.ASF(s, f);
                if (!(asf < min_ASF)) continue;
                min_ASF = asf;
                min_indv = s;
            }
            extremePoints.add(min_indv);
        }
        return extremePoints;
    }

    public List<Double> guassianElimination(List<List<Double>> A, List<Double> b) {
        int i;
        ArrayList<Double> x = new ArrayList<Double>();
        int N = A.size();
        for (i = 0; i < N; ++i) {
            A.get(i).add(b.get(i));
        }
        for (int base = 0; base < N - 1; ++base) {
            for (int target = base + 1; target < N; ++target) {
                double ratio = A.get(target).get(base) / A.get(base).get(base);
                for (int term = 0; term < A.get(base).size(); ++term) {
                    A.get(target).set(term, A.get(target).get(term) - A.get(base).get(term) * ratio);
                }
            }
        }
        for (i = 0; i < N; ++i) {
            x.add(0.0);
        }
        for (i = N - 1; i >= 0; --i) {
            for (int known = i + 1; known < N; ++known) {
                A.get(i).set(N, A.get(i).get(N) - A.get(i).get(known) * (Double)x.get(known));
            }
            x.set(i, A.get(i).get(N) / A.get(i).get(i));
        }
        return x;
    }

    public List<Double> constructHyperplane(List<S> population, List<S> extreme_points) {
        boolean duplicate = false;
        for (int i = 0; !duplicate && i < extreme_points.size(); ++i) {
            for (int j = i + 1; !duplicate && j < extreme_points.size(); ++j) {
                duplicate = ((Solution)extreme_points.get(i)).equals(extreme_points.get(j));
            }
        }
        ArrayList<Double> intercepts = new ArrayList<Double>();
        if (duplicate) {
            for (int f = 0; f < this.numberOfObjectives; ++f) {
                intercepts.add(((Solution)extreme_points.get(f)).getObjective(f));
            }
        } else {
            ArrayList<Double> b = new ArrayList<Double>();
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                b.add(1.0);
            }
            ArrayList<List<Double>> A = new ArrayList<List<Double>>();
            for (Solution s : extreme_points) {
                ArrayList<Double> aux = new ArrayList<Double>();
                for (int i = 0; i < this.numberOfObjectives; ++i) {
                    aux.add(s.getObjective(i));
                }
                A.add(aux);
            }
            List<Double> x = this.guassianElimination(A, b);
            for (int f = 0; f < this.numberOfObjectives; ++f) {
                intercepts.add(1.0 / x.get(f));
            }
        }
        return intercepts;
    }

    public void normalizeObjectives(List<S> population, List<Double> intercepts, List<Double> ideal_point) {
        for (int t = 0; t < this.fronts.size(); ++t) {
            for (Solution s : this.fronts.get(t)) {
                for (int f = 0; f < this.numberOfObjectives; ++f) {
                    Object conv_obj = this.getAttribute(s);
                    if (Math.abs(intercepts.get(f) - ideal_point.get(f)) > 1.0E-9) {
                        conv_obj.set(f, (Double)conv_obj.get(f) / (intercepts.get(f) - ideal_point.get(f)));
                        continue;
                    }
                    conv_obj.set(f, (Double)conv_obj.get(f) / 1.0E-9);
                }
            }
        }
    }

    public double perpendicularDistance(List<Double> direction, List<Double> point) {
        double numerator = 0.0;
        double denominator = 0.0;
        for (int i = 0; i < direction.size(); ++i) {
            numerator += direction.get(i) * point.get(i);
            denominator += Math.pow(direction.get(i), 2.0);
        }
        double k = numerator / denominator;
        double d = 0.0;
        for (int i = 0; i < direction.size(); ++i) {
            d += Math.pow(k * direction.get(i) - point.get(i), 2.0);
        }
        return Math.sqrt(d);
    }

    public void associate(List<S> population) {
        for (int t = 0; t < this.fronts.size(); ++t) {
            for (Solution s : this.fronts.get(t)) {
                int min_rp = -1;
                double min_dist = Double.MAX_VALUE;
                for (int r = 0; r < this.referencePoints.size(); ++r) {
                    double d = this.perpendicularDistance(this.referencePoints.get((int)r).position, (List<Double>)this.getAttribute(s));
                    if (!(d < min_dist)) continue;
                    min_dist = d;
                    min_rp = r;
                }
                if (t + 1 != this.fronts.size()) {
                    this.referencePoints.get(min_rp).AddMember();
                    continue;
                }
                this.referencePoints.get(min_rp).AddPotentialMember(s, min_dist);
            }
        }
    }

    int FindNicheReferencePoint() {
        int min_size = Integer.MAX_VALUE;
        for (ReferencePoint<S> referencePoint : this.referencePoints) {
            min_size = Math.min(min_size, referencePoint.MemberSize());
        }
        ArrayList<Integer> min_rps = new ArrayList<Integer>();
        for (int r = 0; r < this.referencePoints.size(); ++r) {
            if (this.referencePoints.get(r).MemberSize() != min_size) continue;
            min_rps.add(r);
        }
        return (Integer)min_rps.get(min_rps.size() > 1 ? JMetalRandom.getInstance().nextInt(0, min_rps.size() - 1) : 0);
    }

    S SelectClusterMember(ReferencePoint<S> rp) {
        S chosen = null;
        if (rp.HasPotentialMember()) {
            chosen = rp.MemberSize() == 0 ? (S)rp.FindClosestMember() : (S)rp.RandomMember();
        }
        return chosen;
    }

    @Override
    public List<S> execute(List<S> source) throws JMetalException {
        if (source.size() == this.solutionsToSelect) {
            return source;
        }
        List<Double> ideal_point = this.translateObjectives(source);
        List<S> extreme_points = this.findExtremePoints(source);
        List<Double> intercepts = this.constructHyperplane(source, extreme_points);
        this.normalizeObjectives(source, intercepts, ideal_point);
        this.associate(source);
        while (source.size() < this.solutionsToSelect) {
            int min_rp = this.FindNicheReferencePoint();
            S chosen = this.SelectClusterMember(this.referencePoints.get(min_rp));
            if (chosen == null) {
                this.referencePoints.remove(min_rp);
                continue;
            }
            this.referencePoints.get(min_rp).AddMember();
            this.referencePoints.get(min_rp).RemovePotentialMember(chosen);
            source.add(chosen);
        }
        return source;
    }

    @Override
    public void setAttribute(S solution, List<Double> value) {
        solution.setAttribute(this.getAttributeID(), value);
    }

    @Override
    public List<Double> getAttribute(S solution) {
        return (List)solution.getAttribute(this.getAttributeID());
    }

    @Override
    public Object getAttributeID() {
        return this.getClass();
    }

    public static class Builder<S extends Solution<?>> {
        private List<List<S>> fronts;
        private int solutionsToSelect;
        private List<ReferencePoint<S>> referencePoints;
        private int numberOfObjctives;

        public Builder<S> setSolutionsToSelect(int solutions) {
            this.solutionsToSelect = solutions;
            return this;
        }

        public Builder<S> setFronts(List<List<S>> f) {
            this.fronts = f;
            return this;
        }

        public int getSolutionsToSelet() {
            return this.solutionsToSelect;
        }

        public List<List<S>> getFronts() {
            return this.fronts;
        }

        public EnvironmentalSelection<S> build() {
            return new EnvironmentalSelection(this);
        }

        public List<ReferencePoint<S>> getReferencePoints() {
            return this.referencePoints;
        }

        public Builder<S> setReferencePoints(List<ReferencePoint<S>> referencePoints) {
            this.referencePoints = referencePoints;
            return this;
        }

        public Builder<S> setNumberOfObjectives(int n) {
            this.numberOfObjctives = n;
            return this;
        }

        public int getNumberOfObjectives() {
            return this.numberOfObjctives;
        }
    }
}

