/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.omopso;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractParticleSwarmOptimization;
import org.uma.jmetal.operator.impl.mutation.NonUniformMutation;
import org.uma.jmetal.operator.impl.mutation.UniformMutation;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.comparator.CrowdingDistanceComparator;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.solutionattribute.impl.CrowdingDistance;

public class OMOPSO
extends AbstractParticleSwarmOptimization<DoubleSolution, List<DoubleSolution>> {
    private DoubleProblem problem;
    SolutionListEvaluator<DoubleSolution> evaluator;
    private int swarmSize;
    private int archiveSize;
    private int maxIterations;
    private int currentIteration;
    private List<DoubleSolution> swarm;
    private DoubleSolution[] localBest;
    private CrowdingDistanceArchive<DoubleSolution> leaderArchive;
    private NonDominatedSolutionListArchive<DoubleSolution> epsilonArchive;
    private double[][] speed;
    private Comparator<DoubleSolution> dominanceComparator;
    private Comparator<DoubleSolution> crowdingDistanceComparator;
    private UniformMutation uniformMutation;
    private NonUniformMutation nonUniformMutation;
    private double eta = 0.0075;
    private JMetalRandom randomGenerator;
    private CrowdingDistance<DoubleSolution> crowdingDistance;

    public OMOPSO(DoubleProblem problem, SolutionListEvaluator<DoubleSolution> evaluator, int swarmSize, int maxIterations, int archiveSize, UniformMutation uniformMutation, NonUniformMutation nonUniformMutation) {
        this.problem = problem;
        this.evaluator = evaluator;
        this.swarmSize = swarmSize;
        this.maxIterations = maxIterations;
        this.archiveSize = archiveSize;
        this.uniformMutation = uniformMutation;
        this.nonUniformMutation = nonUniformMutation;
        this.localBest = new DoubleSolution[swarmSize];
        this.leaderArchive = new CrowdingDistanceArchive(this.archiveSize);
        this.epsilonArchive = new NonDominatedSolutionListArchive(new DominanceComparator(this.eta));
        this.dominanceComparator = new DominanceComparator<DoubleSolution>();
        this.crowdingDistanceComparator = new CrowdingDistanceComparator<DoubleSolution>();
        this.speed = new double[swarmSize][problem.getNumberOfVariables()];
        this.randomGenerator = JMetalRandom.getInstance();
        this.crowdingDistance = new CrowdingDistance();
    }

    @Override
    protected void initProgress() {
        this.currentIteration = 1;
        this.crowdingDistance.computeDensityEstimator(this.leaderArchive.getSolutionList());
    }

    @Override
    protected void updateProgress() {
        ++this.currentIteration;
        this.crowdingDistance.computeDensityEstimator(this.leaderArchive.getSolutionList());
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.currentIteration >= this.maxIterations;
    }

    @Override
    protected List<DoubleSolution> createInitialSwarm() {
        ArrayList<DoubleSolution> swarm = new ArrayList<DoubleSolution>(this.swarmSize);
        for (int i = 0; i < this.swarmSize; ++i) {
            DoubleSolution newSolution = (DoubleSolution)this.problem.createSolution();
            swarm.add(newSolution);
        }
        return swarm;
    }

    @Override
    protected List<DoubleSolution> evaluateSwarm(List<DoubleSolution> swarm) {
        swarm = this.evaluator.evaluate(swarm, this.problem);
        return swarm;
    }

    @Override
    public List<DoubleSolution> getResult() {
        return this.epsilonArchive.getSolutionList();
    }

    @Override
    protected void initializeLeader(List<DoubleSolution> swarm) {
        for (DoubleSolution solution : swarm) {
            DoubleSolution particle = (DoubleSolution)solution.copy();
            if (!this.leaderArchive.add(particle)) continue;
            this.epsilonArchive.add((DoubleSolution)particle.copy());
        }
    }

    @Override
    protected void initializeParticlesMemory(List<DoubleSolution> swarm) {
        for (int i = 0; i < swarm.size(); ++i) {
            DoubleSolution particle;
            this.localBest[i] = particle = (DoubleSolution)swarm.get(i).copy();
        }
    }

    @Override
    protected void updateVelocity(List<DoubleSolution> swarm) {
        for (int i = 0; i < this.swarmSize; ++i) {
            DoubleSolution two;
            DoubleSolution particle = swarm.get(i);
            DoubleSolution bestParticle = this.localBest[i];
            int pos1 = this.randomGenerator.nextInt(0, this.leaderArchive.getSolutionList().size() - 1);
            int pos2 = this.randomGenerator.nextInt(0, this.leaderArchive.getSolutionList().size() - 1);
            DoubleSolution one = (DoubleSolution)this.leaderArchive.getSolutionList().get(pos1);
            DoubleSolution bestGlobal = this.crowdingDistanceComparator.compare(one, two = (DoubleSolution)this.leaderArchive.getSolutionList().get(pos2)) < 1 ? one : two;
            double r1 = this.randomGenerator.nextDouble();
            double r2 = this.randomGenerator.nextDouble();
            double C1 = this.randomGenerator.nextDouble(1.5, 2.0);
            double C2 = this.randomGenerator.nextDouble(1.5, 2.0);
            double W = this.randomGenerator.nextDouble(0.1, 0.5);
            for (int var = 0; var < particle.getNumberOfVariables(); ++var) {
                this.speed[i][var] = W * this.speed[i][var] + C1 * r1 * ((Double)bestParticle.getVariableValue(var) - (Double)particle.getVariableValue(var)) + C2 * r2 * ((Double)bestGlobal.getVariableValue(var) - (Double)particle.getVariableValue(var));
            }
        }
    }

    @Override
    protected void updatePosition(List<DoubleSolution> swarm) {
        for (int i = 0; i < this.swarmSize; ++i) {
            DoubleSolution particle = swarm.get(i);
            for (int var = 0; var < particle.getNumberOfVariables(); ++var) {
                particle.setVariableValue(var, (Double)particle.getVariableValue(var) + this.speed[i][var]);
                if ((Double)particle.getVariableValue(var) < this.problem.getLowerBound(var)) {
                    particle.setVariableValue(var, this.problem.getLowerBound(var));
                    this.speed[i][var] = this.speed[i][var] * -1.0;
                }
                if (!((Double)particle.getVariableValue(var) > this.problem.getUpperBound(var))) continue;
                particle.setVariableValue(var, this.problem.getUpperBound(var));
                this.speed[i][var] = this.speed[i][var] * -1.0;
            }
        }
    }

    @Override
    protected void updateParticlesMemory(List<DoubleSolution> swarm) {
        for (int i = 0; i < swarm.size(); ++i) {
            DoubleSolution particle;
            int flag = this.dominanceComparator.compare(swarm.get(i), this.localBest[i]);
            if (flag == 1) continue;
            this.localBest[i] = particle = (DoubleSolution)swarm.get(i).copy();
        }
    }

    @Override
    protected void initializeVelocity(List<DoubleSolution> swarm) {
        for (int i = 0; i < swarm.size(); ++i) {
            for (int j = 0; j < this.problem.getNumberOfVariables(); ++j) {
                this.speed[i][j] = 0.0;
            }
        }
    }

    @Override
    protected void perturbation(List<DoubleSolution> swarm) {
        this.nonUniformMutation.setCurrentIteration(this.currentIteration);
        for (int i = 0; i < swarm.size(); ++i) {
            if (i % 3 == 0) {
                this.nonUniformMutation.execute(swarm.get(i));
                continue;
            }
            if (i % 3 != 1) continue;
            this.uniformMutation.execute(swarm.get(i));
        }
    }

    @Override
    protected void updateLeaders(List<DoubleSolution> swarm) {
        for (DoubleSolution solution : swarm) {
            DoubleSolution particle = (DoubleSolution)solution.copy();
            if (!this.leaderArchive.add(particle)) continue;
            this.epsilonArchive.add((DoubleSolution)particle.copy());
        }
    }

    protected void tearDown() {
        this.evaluator.shutdown();
    }

    @Override
    public String getName() {
        return "OMOPSO";
    }

    @Override
    public String getDescription() {
        return "Optimized MOPSO";
    }
}

