/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.wasfga;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.mombi.AbstractMOMBI;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.ASFWASFGA;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.AbstractUtilityFunctionsSet;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.Normalizer;
import org.uma.jmetal.algorithm.multiobjective.wasfga.util.WASFGARanking;
import org.uma.jmetal.algorithm.multiobjective.wasfga.util.WeightVector;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.solutionattribute.Ranking;

public class WASFGA<S extends Solution<?>>
extends AbstractMOMBI<S> {
    private static final long serialVersionUID = 1L;
    protected int maxEvaluations;
    protected int evaluations;
    protected Normalizer normalizer;
    final AbstractUtilityFunctionsSet<S> achievementScalarizingFunction;
    List<Double> referencePoint = null;

    public WASFGA(Problem<S> problem, int populationSize, int maxIterations, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, SolutionListEvaluator<S> evaluator, List<Double> referencePoint) {
        super(problem, maxIterations, crossoverOperator, mutationOperator, selectionOperator, evaluator);
        this.setMaxPopulationSize(populationSize);
        this.referencePoint = referencePoint;
        this.achievementScalarizingFunction = this.createUtilityFunction();
    }

    public AbstractUtilityFunctionsSet<S> createUtilityFunction() {
        double[][] weights = WeightVector.initUniformWeights2D(0.005, this.getMaxPopulationSize());
        weights = WeightVector.invertWeights(weights, true);
        ASFWASFGA aux = new ASFWASFGA(weights, this.referencePoint);
        return aux;
    }

    public int getPopulationSize() {
        return this.getMaxPopulationSize();
    }

    @Override
    public void specificMOEAComputations() {
        this.updateNadirPoint(this.getPopulation());
        this.updateReferencePoint(this.getPopulation());
    }

    @Override
    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        ArrayList<S> jointPopulation = new ArrayList<S>();
        jointPopulation.addAll(population);
        jointPopulation.addAll(offspringPopulation);
        Ranking ranking = this.computeRanking(jointPopulation);
        return this.selectBest(ranking);
    }

    protected Ranking<S> computeRanking(List<S> solutionList) {
        WASFGARanking<S> ranking = new WASFGARanking<S>(this.achievementScalarizingFunction);
        ranking.computeRanking(solutionList);
        return ranking;
    }

    protected void addRankedSolutionsToPopulation(Ranking<S> ranking, int index, List<S> population) {
        population.addAll(ranking.getSubfront(index));
    }

    protected void addLastRankedSolutionsToPopulation(Ranking<S> ranking, int index, List<S> population) {
        List<S> front = ranking.getSubfront(index);
        int remain = this.getPopulationSize() - population.size();
        population.addAll(front.subList(0, remain));
    }

    protected List<S> selectBest(Ranking<S> ranking) {
        ArrayList population = new ArrayList(this.getPopulationSize());
        int rankingIndex = 0;
        while (this.populationIsNotFull(population)) {
            if (this.subfrontFillsIntoThePopulation(ranking, rankingIndex, population)) {
                this.addRankedSolutionsToPopulation(ranking, rankingIndex, population);
                ++rankingIndex;
                continue;
            }
            this.addLastRankedSolutionsToPopulation(ranking, rankingIndex, population);
        }
        return population;
    }

    private boolean subfrontFillsIntoThePopulation(Ranking<S> ranking, int index, List<S> population) {
        return population.size() + ranking.getSubfront(index).size() < this.getPopulationSize();
    }

    protected AbstractUtilityFunctionsSet<S> getUtilityFunctions() {
        return this.achievementScalarizingFunction;
    }

    @Override
    public List<S> getResult() {
        return this.getNonDominatedSolutions(this.getPopulation());
    }

    protected List<S> getNonDominatedSolutions(List<S> solutionList) {
        return SolutionListUtils.getNondominatedSolutions(solutionList);
    }

    @Override
    public String getName() {
        return "WASFGA";
    }

    @Override
    public String getDescription() {
        return "Weighting Achievement Scalarizing Function Genetic Algorithm";
    }
}

