/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.wasfga.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.AbstractUtilityFunctionsSet;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.GenericSolutionAttribute;

public class WASFGARanking<S extends Solution<?>>
extends GenericSolutionAttribute<S, Integer>
implements Ranking<S> {
    private AbstractUtilityFunctionsSet<S> utilityFunctions;
    private List<List<S>> rankedSubpopulations;
    private int numberOfRanks = 0;

    public WASFGARanking(AbstractUtilityFunctionsSet<S> utilityFunctions) {
        this.utilityFunctions = utilityFunctions;
    }

    @Override
    public Ranking<S> computeRanking(List<S> population) {
        this.numberOfRanks = (population.size() + 1) / this.utilityFunctions.getSize();
        this.rankedSubpopulations = new ArrayList<List<S>>(this.numberOfRanks);
        for (int i = 0; i < this.numberOfRanks; ++i) {
            this.rankedSubpopulations.add(new ArrayList());
        }
        LinkedList<S> temporalList = new LinkedList<S>();
        temporalList.addAll(population);
        for (int idx = 0; idx < this.numberOfRanks; ++idx) {
            for (int weigth = 0; weigth < this.utilityFunctions.getSize(); ++weigth) {
                int toRemoveIdx = 0;
                double minimumValue = this.utilityFunctions.evaluate((Solution)temporalList.get(0), weigth);
                for (int solutionIdx = 1; solutionIdx < temporalList.size(); ++solutionIdx) {
                    double value = this.utilityFunctions.evaluate((Solution)temporalList.get(solutionIdx), weigth);
                    if (!(value < minimumValue)) continue;
                    minimumValue = value;
                    toRemoveIdx = solutionIdx;
                }
                Solution solutionToInsert = (Solution)temporalList.remove(toRemoveIdx);
                this.setAttribute(solutionToInsert, idx);
                this.rankedSubpopulations.get(idx).add(solutionToInsert);
            }
        }
        return this;
    }

    @Override
    public List<S> getSubfront(int rank) {
        return this.rankedSubpopulations.get(rank);
    }

    @Override
    public int getNumberOfSubfronts() {
        return this.rankedSubpopulations.size();
    }

    public AbstractUtilityFunctionsSet<S> getUtilityFunctions() {
        return this.utilityFunctions;
    }
}

