/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.wasfga.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.uma.jmetal.util.JMetalException;

public class WeightVector {
    public static double[][] initUniformWeights2D(double epsilon, int numberOfWeights) {
        double[][] weights = new double[numberOfWeights][2];
        double jump = (1.0 - 2.0 * epsilon) / (double)(numberOfWeights - 1);
        double w = epsilon;
        for (int indexOfWeight = 0; indexOfWeight < numberOfWeights; ++indexOfWeight) {
            weights[indexOfWeight][0] = w;
            weights[indexOfWeight][1] = 1.0 - w;
            w += jump;
        }
        return weights;
    }

    public static double[][] getWeightsFromFile(String filePath) {
        double[][] weights = new double[0][0];
        Vector<double[]> listOfWeights = new Vector<double[]>();
        try {
            FileInputStream fis = new FileInputStream(filePath);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            int numberOfObjectives = 0;
            int i = 0;
            int j = 0;
            String aux = br.readLine();
            while (aux != null) {
                StringTokenizer st = new StringTokenizer(aux);
                j = 0;
                numberOfObjectives = st.countTokens();
                double[] weight = new double[numberOfObjectives];
                while (st.hasMoreTokens()) {
                    weight[j] = new Double(st.nextToken());
                    ++j;
                }
                listOfWeights.add(weight);
                aux = br.readLine();
                ++i;
            }
            br.close();
            weights = new double[listOfWeights.size()][numberOfObjectives];
            for (int indexWeight = 0; indexWeight < listOfWeights.size(); ++indexWeight) {
                for (int indexOfObjective = 0; indexOfObjective < numberOfObjectives; ++indexOfObjective) {
                    weights[indexWeight][indexOfObjective] = ((double[])listOfWeights.get(indexWeight))[indexOfObjective];
                }
            }
        }
        catch (Exception e) {
            throw new JMetalException("getWeightsFromFile: failed when reading for file: " + filePath);
        }
        return weights;
    }

    public static double[][] invertWeights(double[][] weights, boolean b) {
        double[][] result = new double[weights.length][weights[0].length];
        for (int indexOfWeight = 0; indexOfWeight < weights.length; ++indexOfWeight) {
            if (b) {
                int indexOfComponent;
                double sum = 0.0;
                for (indexOfComponent = 0; indexOfComponent < weights[indexOfWeight].length; ++indexOfComponent) {
                    sum += 1.0 / weights[indexOfWeight][indexOfComponent];
                }
                for (indexOfComponent = 0; indexOfComponent < weights[indexOfWeight].length; ++indexOfComponent) {
                    result[indexOfWeight][indexOfComponent] = 1.0 / weights[indexOfWeight][indexOfComponent] / sum;
                }
                continue;
            }
            for (int indexOfComponent = 0; indexOfComponent < weights[indexOfWeight].length; ++indexOfComponent) {
                result[indexOfWeight][indexOfComponent] = 1.0 / weights[indexOfWeight][indexOfComponent];
            }
        }
        return result;
    }

    public static enum NORMALIZE {
        TRUE,
        FALSE;

    }
}

