/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.experiment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.mocell.MOCellBuilder;
import org.uma.jmetal.algorithm.multiobjective.mochc.MOCHC;
import org.uma.jmetal.algorithm.multiobjective.mochc.MOCHCBuilder;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.spea2.SPEA2Builder;
import org.uma.jmetal.operator.impl.crossover.HUXCrossover;
import org.uma.jmetal.operator.impl.crossover.SinglePointCrossover;
import org.uma.jmetal.operator.impl.mutation.BitFlipMutation;
import org.uma.jmetal.operator.impl.selection.RandomSelection;
import org.uma.jmetal.operator.impl.selection.RankingAndCrowdingSelection;
import org.uma.jmetal.problem.BinaryProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.multiobjective.OneZeroMax;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT5;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.qualityindicator.impl.hypervolume.PISAHypervolume;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.ExperimentBuilder;
import org.uma.jmetal.util.experiment.component.ComputeQualityIndicators;
import org.uma.jmetal.util.experiment.component.ExecuteAlgorithms;
import org.uma.jmetal.util.experiment.component.GenerateBoxplotsWithR;
import org.uma.jmetal.util.experiment.component.GenerateFriedmanTestTables;
import org.uma.jmetal.util.experiment.component.GenerateLatexTablesWithStatistics;
import org.uma.jmetal.util.experiment.component.GenerateReferenceParetoFront;
import org.uma.jmetal.util.experiment.component.GenerateWilcoxonTestTablesWithR;
import org.uma.jmetal.util.experiment.util.TaggedAlgorithm;

public class BinaryProblemsStudy {
    private static final int INDEPENDENT_RUNS = 25;

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            throw new JMetalException("Needed arguments: experimentBaseDirectory referenceFrontDirectory");
        }
        String experimentBaseDirectory = args[0];
        String referenceFrontDirectory = args[1];
        List problemList = Arrays.asList(new ZDT5(), new OneZeroMax(512));
        List algorithmList = BinaryProblemsStudy.configureAlgorithmList(problemList, 25);
        Experiment experiment = new ExperimentBuilder("BinaryProblemsStudy").setAlgorithmList(algorithmList).setProblemList(problemList).setExperimentBaseDirectory(experimentBaseDirectory).setOutputParetoFrontFileName("FUN").setOutputParetoSetFileName("VAR").setReferenceFrontDirectory(referenceFrontDirectory).setIndicatorList(Arrays.asList(new Epsilon(), new Spread(), new GenerationalDistance(), new PISAHypervolume(), new InvertedGenerationalDistance(), new InvertedGenerationalDistancePlus())).setIndependentRuns(25).setNumberOfCores(8).build();
        new ExecuteAlgorithms(experiment).run();
        new GenerateReferenceParetoFront(experiment).run();
        new ComputeQualityIndicators(experiment).run();
        new GenerateLatexTablesWithStatistics(experiment).run();
        new GenerateWilcoxonTestTablesWithR(experiment).run();
        new GenerateFriedmanTestTables(experiment).run();
        new GenerateBoxplotsWithR(experiment).setRows(1).setColumns(2).setDisplayNotch().run();
    }

    static List<TaggedAlgorithm<List<BinarySolution>>> configureAlgorithmList(List<Problem<BinarySolution>> problemList, int independentRuns) {
        ArrayList<TaggedAlgorithm<List<BinarySolution>>> algorithms = new ArrayList<TaggedAlgorithm<List<BinarySolution>>>();
        for (int run = 0; run < independentRuns; ++run) {
            Algorithm algorithm;
            for (Problem<BinarySolution> problem : problemList) {
                algorithm = new NSGAIIBuilder<BinarySolution>(problem, new SinglePointCrossover(1.0), new BitFlipMutation(1.0 / (double)((BinaryProblem)problem).getNumberOfBits(0))).setMaxEvaluations(25000).setPopulationSize(100).build();
                algorithms.add(new TaggedAlgorithm(algorithm, problem, run));
            }
            for (Problem<BinarySolution> problem : problemList) {
                algorithm = new SPEA2Builder<BinarySolution>(problem, new SinglePointCrossover(1.0), new BitFlipMutation(1.0 / (double)((BinaryProblem)problem).getNumberOfBits(0))).setMaxIterations(250).setPopulationSize(100).build();
                algorithms.add(new TaggedAlgorithm(algorithm, problem, run));
            }
            for (Problem<BinarySolution> problem : problemList) {
                algorithm = new MOCellBuilder<BinarySolution>(problem, new SinglePointCrossover(1.0), new BitFlipMutation(1.0 / (double)((BinaryProblem)problem).getNumberOfBits(0))).setPopulationSize(100).setMaxEvaluations(25000).setArchive(new CrowdingDistanceArchive(100)).build();
                algorithms.add(new TaggedAlgorithm(algorithm, problem, run));
            }
            for (Problem<BinarySolution> problem : problemList) {
                HUXCrossover crossoverOperator = new HUXCrossover(1.0);
                RandomSelection<BinarySolution> parentsSelection = new RandomSelection<BinarySolution>();
                RankingAndCrowdingSelection<BinarySolution> newGenerationSelection = new RankingAndCrowdingSelection<BinarySolution>(100);
                BitFlipMutation mutationOperator = new BitFlipMutation(0.35);
                MOCHC algorithm2 = new MOCHCBuilder((BinaryProblem)problem).setInitialConvergenceCount(0.25).setConvergenceValue(3).setPreservedPopulation(0.05).setPopulationSize(100).setMaxEvaluations(25000).setCrossover(crossoverOperator).setNewGenerationSelection(newGenerationSelection).setCataclysmicMutation(mutationOperator).setParentSelection(parentsSelection).setEvaluator(new SequentialSolutionListEvaluator<BinarySolution>()).build();
                algorithms.add(new TaggedAlgorithm<List<BinarySolution>>(algorithm2, problem, run));
            }
        }
        return algorithms;
    }
}

