/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.experiment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT1;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT2;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT3;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT4;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT6;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.qualityindicator.impl.hypervolume.PISAHypervolume;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.ExperimentBuilder;
import org.uma.jmetal.util.experiment.component.ComputeQualityIndicators;
import org.uma.jmetal.util.experiment.component.ExecuteAlgorithms;
import org.uma.jmetal.util.experiment.component.GenerateBoxplotsWithR;
import org.uma.jmetal.util.experiment.component.GenerateFriedmanTestTables;
import org.uma.jmetal.util.experiment.component.GenerateLatexTablesWithStatistics;
import org.uma.jmetal.util.experiment.component.GenerateWilcoxonTestTablesWithR;
import org.uma.jmetal.util.experiment.util.TaggedAlgorithm;

public class NSGAIIStudy {
    private static final int INDEPENDENT_RUNS = 25;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new JMetalException("Missing argument: experiment base directory");
        }
        String experimentBaseDirectory = args[0];
        List problemList = Arrays.asList(new ZDT1(), new ZDT2(), new ZDT3(), new ZDT4(), new ZDT6());
        List algorithmList = NSGAIIStudy.configureAlgorithmList(problemList, 25);
        List<String> referenceFrontFileNames = Arrays.asList("ZDT1.pf", "ZDT2.pf", "ZDT3.pf", "ZDT4.pf", "ZDT6.pf");
        Experiment experiment = new ExperimentBuilder("NSGAIIStudy").setAlgorithmList(algorithmList).setProblemList(problemList).setExperimentBaseDirectory(experimentBaseDirectory).setOutputParetoFrontFileName("FUN").setOutputParetoSetFileName("VAR").setReferenceFrontDirectory("/pareto_fronts").setReferenceFrontFileNames(referenceFrontFileNames).setIndicatorList(Arrays.asList(new Epsilon(), new Spread(), new GenerationalDistance(), new PISAHypervolume(), new InvertedGenerationalDistance(), new InvertedGenerationalDistancePlus())).setIndependentRuns(25).setNumberOfCores(8).build();
        new ExecuteAlgorithms(experiment).run();
        new ComputeQualityIndicators(experiment).run();
        new GenerateLatexTablesWithStatistics(experiment).run();
        new GenerateWilcoxonTestTablesWithR(experiment).run();
        new GenerateFriedmanTestTables(experiment).run();
        new GenerateBoxplotsWithR(experiment).setRows(3).setColumns(3).run();
    }

    static List<TaggedAlgorithm<List<DoubleSolution>>> configureAlgorithmList(List<Problem<DoubleSolution>> problemList, int independentRuns) {
        ArrayList<TaggedAlgorithm<List<DoubleSolution>>> algorithms = new ArrayList<TaggedAlgorithm<List<DoubleSolution>>>();
        for (int run = 0; run < independentRuns; ++run) {
            Algorithm algorithm;
            int i;
            for (i = 0; i < problemList.size(); ++i) {
                algorithm = new NSGAIIBuilder<DoubleSolution>(problemList.get(i), new SBXCrossover(1.0, 5.0), new PolynomialMutation(1.0 / (double)problemList.get(i).getNumberOfVariables(), 10.0)).setMaxEvaluations(25000).setPopulationSize(100).build();
                algorithms.add(new TaggedAlgorithm(algorithm, "NSGAIIa", problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                algorithm = new NSGAIIBuilder<DoubleSolution>(problemList.get(i), new SBXCrossover(1.0, 20.0), new PolynomialMutation(1.0 / (double)problemList.get(i).getNumberOfVariables(), 20.0)).setMaxEvaluations(25000).setPopulationSize(100).build();
                algorithms.add(new TaggedAlgorithm(algorithm, "NSGAIIb", problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                algorithm = new NSGAIIBuilder<DoubleSolution>(problemList.get(i), new SBXCrossover(1.0, 40.0), new PolynomialMutation(1.0 / (double)problemList.get(i).getNumberOfVariables(), 40.0)).setMaxEvaluations(25000).setPopulationSize(100).build();
                algorithms.add(new TaggedAlgorithm(algorithm, "NSGAIIc", problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                algorithm = new NSGAIIBuilder<DoubleSolution>(problemList.get(i), new SBXCrossover(1.0, 80.0), new PolynomialMutation(1.0 / (double)problemList.get(i).getNumberOfVariables(), 80.0)).setMaxEvaluations(25000).setPopulationSize(100).build();
                algorithms.add(new TaggedAlgorithm(algorithm, "NSGAIId", problemList.get(i), run));
            }
        }
        return algorithms;
    }
}

