/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.experiment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSO;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSOBuilder;
import org.uma.jmetal.algorithm.multiobjective.spea2.SPEA2Builder;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT1;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT2;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT3;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT4;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT6;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.qualityindicator.impl.hypervolume.PISAHypervolume;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.ExperimentBuilder;
import org.uma.jmetal.util.experiment.component.ComputeQualityIndicators;
import org.uma.jmetal.util.experiment.component.ExecuteAlgorithms;
import org.uma.jmetal.util.experiment.component.GenerateBoxplotsWithR;
import org.uma.jmetal.util.experiment.component.GenerateFriedmanTestTables;
import org.uma.jmetal.util.experiment.component.GenerateLatexTablesWithStatistics;
import org.uma.jmetal.util.experiment.component.GenerateWilcoxonTestTablesWithR;
import org.uma.jmetal.util.experiment.util.TaggedAlgorithm;

public class ZDTStudy {
    private static final int INDEPENDENT_RUNS = 25;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new JMetalException("Missing argument: experiment base directory");
        }
        String experimentBaseDirectory = args[0];
        List problemList = Arrays.asList(new ZDT1(), new ZDT2(), new ZDT3(), new ZDT4(), new ZDT6());
        List<String> referenceFrontFileNames = Arrays.asList("ZDT1.pf", "ZDT2.pf", "ZDT3.pf", "ZDT4.pf", "ZDT6.pf");
        List algorithmList = ZDTStudy.configureAlgorithmList(problemList, 25);
        Experiment experiment = new ExperimentBuilder("ZDTStudy").setAlgorithmList(algorithmList).setProblemList(problemList).setReferenceFrontDirectory("/pareto_fronts").setReferenceFrontFileNames(referenceFrontFileNames).setExperimentBaseDirectory(experimentBaseDirectory).setOutputParetoFrontFileName("FUN").setOutputParetoSetFileName("VAR").setIndicatorList(Arrays.asList(new Epsilon(), new Spread(), new GenerationalDistance(), new PISAHypervolume(), new InvertedGenerationalDistance(), new InvertedGenerationalDistancePlus())).setIndependentRuns(25).setNumberOfCores(8).build();
        new ExecuteAlgorithms(experiment).run();
        new ComputeQualityIndicators(experiment).run();
        new GenerateLatexTablesWithStatistics(experiment).run();
        new GenerateWilcoxonTestTablesWithR(experiment).run();
        new GenerateFriedmanTestTables(experiment).run();
        new GenerateBoxplotsWithR(experiment).setRows(3).setColumns(3).setDisplayNotch().run();
    }

    static List<TaggedAlgorithm<List<DoubleSolution>>> configureAlgorithmList(List<Problem<DoubleSolution>> problemList, int independentRuns) {
        ArrayList<TaggedAlgorithm<List<DoubleSolution>>> algorithms = new ArrayList<TaggedAlgorithm<List<DoubleSolution>>>();
        for (int run = 0; run < independentRuns; ++run) {
            int i;
            for (i = 0; i < problemList.size(); ++i) {
                double mutationProbability = 1.0 / (double)problemList.get(i).getNumberOfVariables();
                double mutationDistributionIndex = 20.0;
                SMPSO algorithm = new SMPSOBuilder((DoubleProblem)problemList.get(i), new CrowdingDistanceArchive<DoubleSolution>(100)).setMutation(new PolynomialMutation(mutationProbability, mutationDistributionIndex)).setMaxIterations(250).setSwarmSize(100).setSolutionListEvaluator(new SequentialSolutionListEvaluator<DoubleSolution>()).build();
                algorithms.add(new TaggedAlgorithm<List<DoubleSolution>>(algorithm, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                Algorithm algorithm = new NSGAIIBuilder<DoubleSolution>(problemList.get(i), new SBXCrossover(1.0, 20.0), new PolynomialMutation(1.0 / (double)problemList.get(i).getNumberOfVariables(), 20.0)).build();
                algorithms.add(new TaggedAlgorithm(algorithm, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                Algorithm algorithm = new SPEA2Builder<DoubleSolution>(problemList.get(i), new SBXCrossover(1.0, 10.0), new PolynomialMutation(1.0 / (double)problemList.get(i).getNumberOfVariables(), 20.0)).build();
                algorithms.add(new TaggedAlgorithm(algorithm, problemList.get(i), run));
            }
        }
        return algorithms;
    }
}

