/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;

public class Fonseca
extends AbstractDoubleProblem {
    public Fonseca() {
        this.setNumberOfVariables(3);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(0);
        this.setName("Fonseca");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-4.0);
            upperLimit.add(4.0);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        int numberOfVariables = this.getNumberOfVariables();
        double[] f = new double[this.getNumberOfObjectives()];
        double[] x = new double[numberOfVariables];
        for (int i = 0; i < numberOfVariables; ++i) {
            x[i] = (Double)solution.getVariableValue(i);
        }
        double sum1 = 0.0;
        for (int i = 0; i < numberOfVariables; ++i) {
            sum1 += StrictMath.pow(x[i] - 1.0 / StrictMath.sqrt(numberOfVariables), 2.0);
        }
        double exp1 = StrictMath.exp(-1.0 * sum1);
        f[0] = 1.0 - exp1;
        double sum2 = 0.0;
        for (int i = 0; i < numberOfVariables; ++i) {
            sum2 += StrictMath.pow(x[i] + 1.0 / StrictMath.sqrt(numberOfVariables), 2.0);
        }
        double exp2 = StrictMath.exp(-1.0 * sum2);
        f[1] = 1.0 - exp2;
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
    }
}

