/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cdtlz;

import java.util.HashMap;
import java.util.Map;
import org.uma.jmetal.problem.ConstrainedProblem;
import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ2;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.solutionattribute.impl.NumberOfViolatedConstraints;
import org.uma.jmetal.util.solutionattribute.impl.OverallConstraintViolation;

public class ConvexC2_DTLZ2
extends DTLZ2
implements ConstrainedProblem<DoubleSolution> {
    public OverallConstraintViolation<DoubleSolution> overallConstraintViolationDegree;
    public NumberOfViolatedConstraints<DoubleSolution> numberOfViolatedConstraints;
    private static Map<Integer, Double> rValue = new HashMap<Integer, Double>();

    public ConvexC2_DTLZ2(int numberOfVariables, int numberOfObjectives) {
        super(numberOfVariables, numberOfObjectives);
        this.setNumberOfConstraints(1);
        this.overallConstraintViolationDegree = new OverallConstraintViolation();
        this.numberOfViolatedConstraints = new NumberOfViolatedConstraints();
    }

    @Override
    public void evaluateConstraints(DoubleSolution solution) {
        double[] constraint = new double[this.getNumberOfConstraints()];
        double sum = 0.0;
        for (int i = 0; i < this.getNumberOfObjectives(); ++i) {
            sum += solution.getObjective(i);
        }
        double lambda = sum / (double)this.getNumberOfObjectives();
        sum = 0.0;
        for (int i = 0; i < this.getNumberOfObjectives(); ++i) {
            sum += Math.pow(solution.getObjective(i) - lambda, 2.0);
        }
        constraint[0] = sum - Math.pow(rValue.get(this.getNumberOfObjectives()), 2.0);
        double overallConstraintViolation = 0.0;
        int violatedConstraints = 0;
        for (int i = 0; i < this.getNumberOfConstraints(); ++i) {
            if (!(constraint[i] < 0.0)) continue;
            overallConstraintViolation += constraint[i];
            ++violatedConstraints;
        }
        this.overallConstraintViolationDegree.setAttribute(solution, overallConstraintViolation);
        this.numberOfViolatedConstraints.setAttribute(solution, violatedConstraints);
    }

    static {
        rValue.put(3, 0.225);
        rValue.put(5, 0.225);
        rValue.put(8, 0.26);
        rValue.put(10, 0.26);
        rValue.put(15, 0.27);
    }
}

