/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.FileNotFoundException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIMeasures;
import org.uma.jmetal.measure.MeasureListener;
import org.uma.jmetal.measure.MeasureManager;
import org.uma.jmetal.measure.impl.BasicMeasure;
import org.uma.jmetal.measure.impl.CountingMeasure;
import org.uma.jmetal.measure.impl.DurationMeasure;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.runner.AbstractAlgorithmRunner;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;

public class NSGAIIMeasuresRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, InterruptedException, FileNotFoundException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT1";
            referenceParetoFront = "jmetal-problem/src/test/resources/pareto_fronts/ZDT1.pf";
        }
        Problem problem = ProblemUtils.loadProblem(problemName);
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        BinaryTournamentSelection selection = new BinaryTournamentSelection(new RankingAndCrowdingDistanceComparator());
        int maxEvaluations = 25000;
        int populationSize = 100;
        Algorithm algorithm = new NSGAIIBuilder<DoubleSolution>(problem, crossover, mutation).setSelectionOperator(selection).setMaxEvaluations(maxEvaluations).setPopulationSize(populationSize).setVariant(NSGAIIBuilder.NSGAIIVariant.Measures).build();
        MeasureManager measureManager = ((NSGAIIMeasures)algorithm).getMeasureManager();
        CountingMeasure currentEvalution = (CountingMeasure)measureManager.getPullMeasure("currentEvaluation");
        DurationMeasure currentComputingTime = (DurationMeasure)measureManager.getPullMeasure("currentExecutionTime");
        BasicMeasure nonDominatedSolutions = (BasicMeasure)measureManager.getPullMeasure("numberOfNonDominatedSolutionsInPopulation");
        BasicMeasure solutionListMeasure = (BasicMeasure)measureManager.getPushMeasure("currentPopulation");
        CountingMeasure iteration2 = (CountingMeasure)measureManager.getPushMeasure("currentEvaluation");
        solutionListMeasure.register(new Listener());
        iteration2.register(new Listener2());
        Thread algorithmThread = new Thread(algorithm);
        algorithmThread.start();
        int i = 0;
        while (currentEvalution.get() < (long)maxEvaluations) {
            TimeUnit.SECONDS.sleep(5L);
            System.out.println("Evaluations (" + i + ")                     : " + currentEvalution.get());
            System.out.println("Computing time (" + i + ")                  : " + currentComputingTime.get());
            System.out.println("Number of Nondominated solutions (" + i + "): " + nonDominatedSolutions.get());
            ++i;
        }
        algorithmThread.join();
        List population = (List)algorithm.getResult();
        long computingTime = currentComputingTime.get();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        NSGAIIMeasuresRunner.printFinalSolutionSet(population);
        if (!referenceParetoFront.equals("")) {
            NSGAIIMeasuresRunner.printQualityIndicators(population, referenceParetoFront);
        }
    }

    private static class Listener2
    implements MeasureListener<Long> {
        private Listener2() {
        }

        @Override
        public synchronized void measureGenerated(Long value) {
            if (value % 50L == 0L) {
                System.out.println("PUSH MEASURE. Iteration: " + value);
            }
        }
    }

    private static class Listener
    implements MeasureListener<List<DoubleSolution>> {
        private int counter = 0;

        private Listener() {
        }

        @Override
        public synchronized void measureGenerated(List<DoubleSolution> solutions) {
            if (this.counter % 10 == 0) {
                System.out.println("PUSH MEASURE. Counter = " + this.counter + " First solution: " + solutions.get(0));
            }
            ++this.counter;
        }
    }
}

