/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.FileNotFoundException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSO;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSOBuilder;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSOMeasures;
import org.uma.jmetal.measure.MeasureListener;
import org.uma.jmetal.measure.MeasureManager;
import org.uma.jmetal.measure.impl.BasicMeasure;
import org.uma.jmetal.measure.impl.CountingMeasure;
import org.uma.jmetal.measure.impl.DurationMeasure;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.runner.AbstractAlgorithmRunner;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.pseudorandom.impl.MersenneTwisterGenerator;

public class SMPSOMeasuresRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, InterruptedException, FileNotFoundException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT4";
            referenceParetoFront = "jmetal-problem/src/test/resources/pareto_fronts/ZDT4.pf";
        }
        DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem(problemName);
        CrowdingDistanceArchive<DoubleSolution> archive = new CrowdingDistanceArchive<DoubleSolution>(100);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        int maxIterations = 250;
        int swarmSize = 100;
        SMPSO algorithm = new SMPSOBuilder(problem, archive).setMutation(mutation).setMaxIterations(maxIterations).setSwarmSize(swarmSize).setRandomGenerator(new MersenneTwisterGenerator()).setSolutionListEvaluator(new SequentialSolutionListEvaluator<DoubleSolution>()).setVariant(SMPSOBuilder.SMPSOVariant.Measures).build();
        MeasureManager measureManager = ((SMPSOMeasures)algorithm).getMeasureManager();
        CountingMeasure currentIteration = (CountingMeasure)measureManager.getPullMeasure("currentIteration");
        DurationMeasure currentComputingTime = (DurationMeasure)measureManager.getPullMeasure("currentExecutionTime");
        BasicMeasure solutionListMeasure = (BasicMeasure)measureManager.getPushMeasure("currentPopulation");
        CountingMeasure iteration2 = (CountingMeasure)measureManager.getPushMeasure("currentIteration");
        solutionListMeasure.register(new Listener());
        iteration2.register(new Listener2());
        Thread algorithmThread = new Thread(algorithm);
        algorithmThread.start();
        int i = 0;
        while (currentIteration.get() < (long)maxIterations) {
            TimeUnit.SECONDS.sleep(5L);
            System.out.println("Iteration (" + i + ")                     : " + currentIteration.get());
            System.out.println("Computing time (" + i + ")                  : " + currentComputingTime.get());
            ++i;
        }
        algorithmThread.join();
        List population = (List)algorithm.getResult();
        long computingTime = currentComputingTime.get();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        SMPSOMeasuresRunner.printFinalSolutionSet(population);
        if (!referenceParetoFront.equals("")) {
            SMPSOMeasuresRunner.printQualityIndicators(population, referenceParetoFront);
        }
    }

    private static class Listener2
    implements MeasureListener<Long> {
        private Listener2() {
        }

        @Override
        public synchronized void measureGenerated(Long value) {
            if (value % 50L == 0L) {
                System.out.println("PUSH MEASURE. Iteration: " + value);
            }
        }
    }

    private static class Listener
    implements MeasureListener<List<DoubleSolution>> {
        private int counter = 0;

        private Listener() {
        }

        @Override
        public synchronized void measureGenerated(List<DoubleSolution> solutions) {
            if (this.counter % 1 == 0) {
                System.out.println("PUSH MEASURE. Counter = " + this.counter + " First solution: " + solutions.get(0));
            }
            ++this.counter;
        }
    }
}

