/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.comparator.ConstraintViolationComparator;
import org.uma.jmetal.util.comparator.impl.OverallConstraintViolationComparator;

public class DominanceComparator<S extends Solution<?>>
implements Comparator<S>,
Serializable {
    private ConstraintViolationComparator<S> constraintViolationComparator;
    private double epsilon = 0.0;

    public DominanceComparator() {
        this(new OverallConstraintViolationComparator(), 0.0);
    }

    public DominanceComparator(double epsilon) {
        this(new OverallConstraintViolationComparator(), epsilon);
    }

    public DominanceComparator(ConstraintViolationComparator<S> constraintComparator) {
        this(constraintComparator, 0.0);
    }

    public DominanceComparator(ConstraintViolationComparator<S> constraintComparator, double epsilon) {
        this.constraintViolationComparator = constraintComparator;
        this.epsilon = epsilon;
    }

    @Override
    public int compare(S solution1, S solution2) {
        if (solution1 == null) {
            throw new JMetalException("Solution1 is null");
        }
        if (solution2 == null) {
            throw new JMetalException("Solution2 is null");
        }
        if (solution1.getNumberOfObjectives() != solution2.getNumberOfObjectives()) {
            throw new JMetalException("Cannot compare because solution1 has " + solution1.getNumberOfObjectives() + " objectives and solution2 has " + solution2.getNumberOfObjectives());
        }
        int result = this.constraintViolationComparator.compare(solution1, solution2);
        if (result == 0) {
            result = this.dominanceTest((Solution<?>)solution1, (Solution<?>)solution2);
        }
        return result;
    }

    private int dominanceTest(Solution<?> solution1, Solution<?> solution2) {
        boolean solution1Dominates = false;
        boolean solution2Dominates = false;
        for (int i = 0; i < solution1.getNumberOfObjectives(); ++i) {
            double value2;
            double value1 = solution1.getObjective(i);
            int flag = value1 / (1.0 + this.epsilon) < (value2 = solution2.getObjective(i)) ? -1 : (value2 / (1.0 + this.epsilon) < value1 ? 1 : 0);
            if (flag == -1) {
                solution1Dominates = true;
            }
            if (flag != 1) continue;
            solution2Dominates = true;
        }
        int result = solution1Dominates == solution2Dominates ? 0 : (solution1Dominates ? -1 : 1);
        return result;
    }
}

