/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.experiment;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.qualityindicator.impl.GenericIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.experiment.ExperimentBuilder;
import org.uma.jmetal.util.experiment.util.TaggedAlgorithm;

public class Experiment<S extends Solution<?>, Result> {
    private String experimentName;
    private List<TaggedAlgorithm<Result>> algorithmList;
    private List<Problem<S>> problemList;
    private String experimentBaseDirectory;
    private String outputParetoFrontFileName;
    private String outputParetoSetFileName;
    private int independentRuns;
    private List<String> referenceFrontFileNames;
    private String referenceFrontDirectory;
    private List<GenericIndicator<S>> indicatorList;
    private int numberOfCores;

    public Experiment(ExperimentBuilder<S, Result> builder) {
        this.experimentName = builder.getExperimentName();
        this.experimentBaseDirectory = builder.getExperimentBaseDirectory();
        this.algorithmList = builder.getAlgorithmList();
        this.problemList = builder.getProblemList();
        this.independentRuns = builder.getIndependentRuns();
        this.outputParetoFrontFileName = builder.getOutputParetoFrontFileName();
        this.outputParetoSetFileName = builder.getOutputParetoSetFileName();
        this.numberOfCores = builder.getNumberOfCores();
        this.referenceFrontDirectory = builder.getReferenceFrontDirectory();
        this.referenceFrontFileNames = builder.getReferenceFrontFileNames();
        this.indicatorList = builder.getIndicatorList();
    }

    public String getExperimentName() {
        return this.experimentName;
    }

    public List<TaggedAlgorithm<Result>> getAlgorithmList() {
        return this.algorithmList;
    }

    public List<Problem<S>> getProblemList() {
        return this.problemList;
    }

    public String getExperimentBaseDirectory() {
        return this.experimentBaseDirectory;
    }

    public String getOutputParetoFrontFileName() {
        return this.outputParetoFrontFileName;
    }

    public String getOutputParetoSetFileName() {
        return this.outputParetoSetFileName;
    }

    public int getIndependentRuns() {
        return this.independentRuns;
    }

    public int getNumberOfCores() {
        return this.numberOfCores;
    }

    public List<String> getReferenceFrontFileNames() {
        return this.referenceFrontFileNames;
    }

    public String getReferenceFrontDirectory() {
        return this.referenceFrontDirectory;
    }

    public List<GenericIndicator<S>> getIndicatorList() {
        return this.indicatorList;
    }

    public void setReferenceFrontDirectory(String referenceFrontDirectory) {
        this.referenceFrontDirectory = referenceFrontDirectory;
    }

    public void setReferenceFrontFileNames(List<String> referenceFrontFileNames) {
        this.referenceFrontFileNames = referenceFrontFileNames;
    }

    public void setAlgorithmList(List<TaggedAlgorithm<Result>> algorithmList) {
        this.algorithmList = algorithmList;
    }

    public void removeDuplicatedAlgorithms() {
        ArrayList<TaggedAlgorithm<Result>> algorithmList = new ArrayList<TaggedAlgorithm<Result>>();
        ArrayList<String> algorithmTagList = new ArrayList<String>();
        for (TaggedAlgorithm<Result> algorithm : this.getAlgorithmList()) {
            if (algorithmTagList.contains(algorithm.getTag())) continue;
            algorithmList.add(algorithm);
            algorithmTagList.add(algorithm.getTag());
        }
        this.setAlgorithmList(algorithmList);
    }
}

