/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.experiment.component;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.qualityindicator.impl.GenericIndicator;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.ExperimentComponent;

public class GenerateBoxplotsWithR<Result>
implements ExperimentComponent {
    private static final String DEFAULT_R_DIRECTORY = "R";
    private final Experiment<?, Result> experiment;
    private int numberOfRows;
    private int numberOfColumns;
    private boolean displayNotch;

    public GenerateBoxplotsWithR(Experiment<?, Result> experimentConfiguration) {
        this.experiment = experimentConfiguration;
        this.experiment.removeDuplicatedAlgorithms();
        this.experiment.removeDuplicatedAlgorithms();
        this.displayNotch = false;
        this.numberOfRows = 3;
        this.numberOfColumns = 3;
    }

    public GenerateBoxplotsWithR<Result> setRows(int rows) {
        this.numberOfRows = rows;
        return this;
    }

    public GenerateBoxplotsWithR<Result> setColumns(int columns) {
        this.numberOfColumns = columns;
        return this;
    }

    public GenerateBoxplotsWithR<Result> setDisplayNotch() {
        this.displayNotch = true;
        return this;
    }

    @Override
    public void run() throws IOException {
        String rDirectoryName = this.experiment.getExperimentBaseDirectory() + "/" + DEFAULT_R_DIRECTORY;
        File rOutput = new File(rDirectoryName);
        if (!rOutput.exists()) {
            boolean result = new File(rDirectoryName).mkdirs();
            System.out.println("Creating " + rDirectoryName + " directory");
        }
        for (GenericIndicator<?> indicator : this.experiment.getIndicatorList()) {
            int i;
            String rFileName = rDirectoryName + "/" + indicator.getName() + ".Boxplot" + ".R";
            FileWriter os = new FileWriter(rFileName, false);
            os.write("postscript(\"" + indicator.getName() + ".Boxplot.eps\", horizontal=FALSE, onefile=FALSE, height=8, width=12, pointsize=10)" + "\n");
            os.write("resultDirectory<-\"../data\"\n");
            os.write("qIndicator <- function(indicator, problem)\n");
            os.write("{\n");
            for (i = 0; i < this.experiment.getAlgorithmList().size(); ++i) {
                String algorithmName = this.experiment.getAlgorithmList().get(i).getTag();
                os.write("file" + algorithmName + "<-paste(resultDirectory, \"" + algorithmName + "\", sep=\"/\")" + "\n");
                os.write("file" + algorithmName + "<-paste(file" + algorithmName + ", " + "problem, sep=\"/\")" + "\n");
                os.write("file" + algorithmName + "<-paste(file" + algorithmName + ", " + "indicator, sep=\"/\")" + "\n");
                os.write(algorithmName + "<-scan(" + "file" + algorithmName + ")" + "\n");
                os.write("\n");
            }
            os.write("algs<-c(");
            for (i = 0; i < this.experiment.getAlgorithmList().size() - 1; ++i) {
                os.write("\"" + this.experiment.getAlgorithmList().get(i).getTag() + "\",");
            }
            os.write("\"" + this.experiment.getAlgorithmList().get(this.experiment.getAlgorithmList().size() - 1).getTag() + "\")" + "\n");
            os.write("boxplot(");
            for (i = 0; i < this.experiment.getAlgorithmList().size(); ++i) {
                os.write(this.experiment.getAlgorithmList().get(i).getTag() + ",");
            }
            if (this.displayNotch) {
                os.write("names=algs, notch = TRUE)\n");
            } else {
                os.write("names=algs, notch = FALSE)\n");
            }
            os.write("titulo <-paste(indicator, problem, sep=\":\")\n");
            os.write("title(main=titulo)\n");
            os.write("}\n");
            os.write("par(mfrow=c(" + this.numberOfRows + "," + this.numberOfColumns + "))" + "\n");
            os.write("indicator<-\"" + indicator.getName() + "\"" + "\n");
            for (Problem<?> problem : this.experiment.getProblemList()) {
                os.write("qIndicator(indicator, \"" + problem.getName() + "\")" + "\n");
            }
            os.close();
        }
    }
}

