/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.experiment.util;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.util.TaggedAlgorithm;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

class EvaluationTask<S extends Solution<?>, Result>
implements Callable<Object> {
    private TaggedAlgorithm<Result> algorithm;
    private int id;
    private String outputDirectoryName;

    public EvaluationTask(TaggedAlgorithm<Result> algorithm, int id, Experiment<?, ?> experimentData) {
        JMetalLogger.logger.info(" Task: " + algorithm.getTag() + ", problem: " + algorithm.getProblem().getName() + ", run: " + id);
        this.algorithm = algorithm;
        this.id = id;
        this.outputDirectoryName = experimentData.getExperimentBaseDirectory() + "/data/" + algorithm.getTag() + "/" + algorithm.getProblem().getName();
        File outputDirectory = new File(this.outputDirectoryName);
        if (!outputDirectory.exists()) {
            boolean result = new File(this.outputDirectoryName).mkdirs();
            if (result) {
                JMetalLogger.logger.info("Creating " + this.outputDirectoryName);
            } else {
                JMetalLogger.logger.severe("Creating " + this.outputDirectoryName + " failed");
            }
        }
    }

    @Override
    public Integer call() throws Exception {
        String funFile = this.outputDirectoryName + "/FUN" + this.id + ".tsv";
        String varFile = this.outputDirectoryName + "/VAR" + this.id + ".tsv";
        JMetalLogger.logger.info(" Running algorithm: " + this.algorithm.getTag() + ", problem: " + this.algorithm.getProblem().getName() + ", run: " + this.id + ", funFile: " + funFile);
        this.algorithm.run();
        Result population = this.algorithm.getResult();
        new SolutionListOutput((List)population).setSeparator("\t").setVarFileOutputContext(new DefaultFileOutputContext(varFile)).setFunFileOutputContext(new DefaultFileOutputContext(funFile)).print();
        return this.id;
    }
}

