/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.experiment.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.util.EvaluationTask;
import org.uma.jmetal.util.experiment.util.TaggedAlgorithm;
import org.uma.jmetal.util.parallel.SynchronousParallelTaskExecutor;

public class MultithreadedExperimentExecutor<S extends Solution<?>, Result>
implements SynchronousParallelTaskExecutor<Object> {
    private Collection<EvaluationTask<S, Result>> taskList;
    private int numberOfThreads;
    private ExecutorService executor;

    public MultithreadedExperimentExecutor(int threads) {
        this.numberOfThreads = threads;
        if (threads == 0) {
            this.numberOfThreads = Runtime.getRuntime().availableProcessors();
        } else if (threads < 0) {
            JMetalLogger.logger.severe("MultithreadedExperimentExecutor: the number of threads cannot be negative number " + threads);
        } else {
            this.numberOfThreads = threads;
        }
        JMetalLogger.logger.info("THREADS: " + this.numberOfThreads);
    }

    @Override
    public void start(Object configuration) {
        this.executor = Executors.newFixedThreadPool(this.numberOfThreads);
        JMetalLogger.logger.info("Cores: " + this.numberOfThreads);
        this.taskList = null;
    }

    @Override
    public void addTask(Object[] taskParameters) {
        if (this.taskList == null) {
            this.taskList = new ArrayList<EvaluationTask<S, Result>>();
        }
        TaggedAlgorithm algorithm = (TaggedAlgorithm)taskParameters[0];
        Integer id = (Integer)taskParameters[1];
        Experiment experimentData = (Experiment)taskParameters[2];
        this.taskList.add(new EvaluationTask(algorithm, id, experimentData));
    }

    @Override
    public Object parallelExecution() {
        List future = null;
        try {
            future = this.executor.invokeAll(this.taskList);
        }
        catch (InterruptedException e1) {
            JMetalLogger.logger.log(Level.SEVERE, "Error", e1);
        }
        Vector<Integer> resultList = new Vector<Integer>();
        for (Future result : future) {
            Object returnValue = null;
            try {
                returnValue = result.get();
                resultList.add(returnValue);
            }
            catch (InterruptedException e) {
                JMetalLogger.logger.log(Level.SEVERE, "Error", e);
            }
            catch (ExecutionException e) {
                JMetalLogger.logger.log(Level.SEVERE, "Error", e);
            }
        }
        this.taskList = null;
        return null;
    }

    @Override
    public void stop() {
        this.executor.shutdown();
    }
}

