/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.naming.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.uma.jmetal.util.naming.DescribedEntity;

public class DescribedEntitySet<Entity extends DescribedEntity>
implements Set<Entity> {
    private final Map<String, Entity> map = new HashMap<String, Entity>();

    @Override
    public boolean add(Entity e) {
        DescribedEntity stored = (DescribedEntity)this.map.get(e.getName());
        if (stored == null) {
            this.map.put(e.getName(), e);
            return true;
        }
        if (stored.equals(e)) {
            return false;
        }
        throw new IllegalArgumentException("Cannot add " + e + ", conflicting name with " + stored);
    }

    @Override
    public boolean addAll(Collection<? extends Entity> c) {
        boolean isModified = false;
        for (DescribedEntity entity : c) {
            isModified |= this.add((Entity)entity);
        }
        return isModified;
    }

    public <E extends Entity> E get(String name) {
        return (E)((DescribedEntity)this.map.get(name));
    }

    @Override
    public boolean remove(Object o) {
        return this.map.values().remove(o);
    }

    public boolean remove(String name) {
        return this.map.keySet().remove(name);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.map.values().removeAll(c);
    }

    @Override
    public boolean contains(Object o) {
        return this.map.values().contains(o);
    }

    public boolean contains(String name) {
        return this.map.keySet().contains(name);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.values().containsAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.map.values().retainAll(c);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Iterator<Entity> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.values().toArray(a);
    }

    public String toString() {
        TreeSet<String> displaySet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int comparison = s1.compareToIgnoreCase(s2);
                return comparison == 0 ? s1.compareTo(s2) : comparison;
            }
        });
        displaySet.addAll(this.map.keySet());
        return displaySet.toString();
    }
}

