/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.gwasfga.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.AbstractUtilityFunctionsSet;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.GenericSolutionAttribute;
import org.uma.jmetal.util.solutionattribute.impl.NumberOfViolatedConstraints;
import org.uma.jmetal.util.solutionattribute.impl.OverallConstraintViolation;

public class GWASFGARanking<S extends Solution<?>>
extends GenericSolutionAttribute<S, Integer>
implements Ranking<S> {
    private int numberOfRanks = 0;
    private AbstractUtilityFunctionsSet<S> utilityFunctionsUtopia;
    private AbstractUtilityFunctionsSet<S> utilityFunctionsNadir;
    private List<List<S>> rankedSubpopulations;
    private NumberOfViolatedConstraints<S> numberOfViolatedConstraints;
    private OverallConstraintViolation<S> overallConstraintViolation;

    public GWASFGARanking(AbstractUtilityFunctionsSet<S> utilityFunctionsUtopia, AbstractUtilityFunctionsSet<S> utilityFunctionsNadir) {
        this.utilityFunctionsUtopia = utilityFunctionsUtopia;
        this.utilityFunctionsNadir = utilityFunctionsNadir;
        this.numberOfViolatedConstraints = new NumberOfViolatedConstraints();
        this.overallConstraintViolation = new OverallConstraintViolation();
    }

    @Override
    public Ranking<S> computeRanking(List<S> population) {
        Solution solutionToInsert;
        int index;
        int numberOfWeights = this.utilityFunctionsNadir.getSize() + this.utilityFunctionsUtopia.getSize();
        LinkedList<Solution> feasibleSolutions = new LinkedList<Solution>();
        LinkedList<Solution> unfeasibleSolutions = new LinkedList<Solution>();
        for (Solution solution : population) {
            if (this.numberOfViolatedConstraints.getAttribute(solution) != null && (Integer)this.numberOfViolatedConstraints.getAttribute(solution) > 0) {
                unfeasibleSolutions.add(solution);
                continue;
            }
            feasibleSolutions.add(solution);
        }
        int numberOfRanksForFeasibleSolutions = feasibleSolutions.size() > 0 ? (feasibleSolutions.size() > numberOfWeights ? (feasibleSolutions.size() + 1) / numberOfWeights : 1) : 0;
        int numberOfRanksForUnfeasibleSolutions = unfeasibleSolutions.size();
        this.numberOfRanks = numberOfRanksForFeasibleSolutions + numberOfRanksForUnfeasibleSolutions;
        this.rankedSubpopulations = new ArrayList<List<S>>(this.numberOfRanks);
        for (int i = 0; i < this.numberOfRanks; ++i) {
            this.rankedSubpopulations.add(new ArrayList());
        }
        if (!feasibleSolutions.isEmpty()) {
            for (index = 0; index < numberOfRanksForFeasibleSolutions; ++index) {
                for (int indexOfWeight = 0; indexOfWeight < numberOfWeights / 2; ++indexOfWeight) {
                    double value;
                    int solutionIdx;
                    if (feasibleSolutions.isEmpty()) continue;
                    int indexOfBestSolution = 0;
                    double minimumValue = this.utilityFunctionsUtopia.evaluate((Solution)feasibleSolutions.get(0), indexOfWeight);
                    for (solutionIdx = 1; solutionIdx < feasibleSolutions.size(); ++solutionIdx) {
                        value = this.utilityFunctionsUtopia.evaluate((Solution)feasibleSolutions.get(solutionIdx), indexOfWeight);
                        if (!(value < minimumValue)) continue;
                        minimumValue = value;
                        indexOfBestSolution = solutionIdx;
                    }
                    solutionToInsert = (Solution)feasibleSolutions.remove(indexOfBestSolution);
                    this.setAttribute(solutionToInsert, index);
                    this.rankedSubpopulations.get(index).add(solutionToInsert);
                    indexOfBestSolution = 0;
                    minimumValue = this.utilityFunctionsNadir.evaluate((Solution)feasibleSolutions.get(0), indexOfWeight);
                    for (solutionIdx = 1; solutionIdx < feasibleSolutions.size(); ++solutionIdx) {
                        value = this.utilityFunctionsNadir.evaluate((Solution)feasibleSolutions.get(solutionIdx), indexOfWeight);
                        if (!(value < minimumValue)) continue;
                        minimumValue = value;
                        indexOfBestSolution = solutionIdx;
                    }
                    solutionToInsert = (Solution)feasibleSolutions.remove(indexOfBestSolution);
                    this.setAttribute(solutionToInsert, index);
                    this.rankedSubpopulations.get(index).add(solutionToInsert);
                }
            }
        }
        if (!unfeasibleSolutions.isEmpty()) {
            int[] rankForUnfeasibleSolutions = this.rankUnfeasibleSolutions(unfeasibleSolutions);
            for (index = 0; index < rankForUnfeasibleSolutions.length; ++index) {
                solutionToInsert = (Solution)unfeasibleSolutions.get(index);
                int rank = rankForUnfeasibleSolutions[index] + numberOfRanksForFeasibleSolutions;
                this.setAttribute(solutionToInsert, rank);
                this.rankedSubpopulations.get(rank).add(solutionToInsert);
            }
        }
        return this;
    }

    protected int[] rankUnfeasibleSolutions(List<S> population) {
        int[] rank = new int[population.size()];
        Arrays.fill(rank, 0);
        for (int indexOfFirstSolution = 0; indexOfFirstSolution < population.size() - 1; ++indexOfFirstSolution) {
            for (int indexOfSecondSolution = indexOfFirstSolution + 1; indexOfSecondSolution < population.size(); ++indexOfSecondSolution) {
                double value;
                int indexOfWeight;
                double overallConstraintViolationSolution2;
                int numberOfViolatedConstraintsBySolution2;
                int numberOfViolatedConstraintsBySolution1 = (Integer)this.numberOfViolatedConstraints.getAttribute((Solution)population.get(indexOfFirstSolution));
                if (numberOfViolatedConstraintsBySolution1 > (numberOfViolatedConstraintsBySolution2 = ((Integer)this.numberOfViolatedConstraints.getAttribute((Solution)population.get(indexOfSecondSolution))).intValue())) {
                    int n = indexOfFirstSolution;
                    rank[n] = rank[n] + 1;
                    continue;
                }
                if (numberOfViolatedConstraintsBySolution1 < numberOfViolatedConstraintsBySolution2) {
                    int n = indexOfSecondSolution;
                    rank[n] = rank[n] + 1;
                    continue;
                }
                double overallConstraintViolationSolution1 = (Double)this.overallConstraintViolation.getAttribute((Solution)population.get(indexOfFirstSolution));
                if (overallConstraintViolationSolution1 > (overallConstraintViolationSolution2 = ((Double)this.overallConstraintViolation.getAttribute((Solution)population.get(indexOfSecondSolution))).doubleValue())) {
                    int n = indexOfSecondSolution;
                    rank[n] = rank[n] + 1;
                    continue;
                }
                if (overallConstraintViolationSolution1 < overallConstraintViolationSolution2) {
                    int n = indexOfFirstSolution;
                    rank[n] = rank[n] + 1;
                    continue;
                }
                double minimumValueSecondSolution = Double.POSITIVE_INFINITY;
                double minimumValueFirstSolution = Double.POSITIVE_INFINITY;
                for (indexOfWeight = 0; indexOfWeight < this.utilityFunctionsNadir.getSize(); ++indexOfWeight) {
                    value = this.utilityFunctionsNadir.evaluate((Solution)population.get(indexOfFirstSolution), indexOfWeight);
                    if (value < minimumValueFirstSolution) {
                        minimumValueFirstSolution = value;
                    }
                    if (!((value = this.utilityFunctionsNadir.evaluate((Solution)population.get(indexOfSecondSolution), indexOfWeight).doubleValue()) < minimumValueSecondSolution)) continue;
                    minimumValueSecondSolution = value;
                }
                for (indexOfWeight = 0; indexOfWeight < this.utilityFunctionsUtopia.getSize(); ++indexOfWeight) {
                    value = this.utilityFunctionsUtopia.evaluate((Solution)population.get(indexOfFirstSolution), indexOfWeight);
                    if (value < minimumValueFirstSolution) {
                        minimumValueFirstSolution = value;
                    }
                    if (!((value = this.utilityFunctionsUtopia.evaluate((Solution)population.get(indexOfSecondSolution), indexOfWeight).doubleValue()) < minimumValueSecondSolution)) continue;
                    minimumValueSecondSolution = value;
                }
                if (minimumValueFirstSolution < minimumValueSecondSolution) {
                    int n = indexOfSecondSolution;
                    rank[n] = rank[n] + 1;
                    continue;
                }
                int n = indexOfFirstSolution;
                rank[n] = rank[n] + 1;
            }
        }
        return rank;
    }

    @Override
    public List<S> getSubfront(int rank) {
        return this.rankedSubpopulations.get(rank);
    }

    @Override
    public int getNumberOfSubfronts() {
        return this.rankedSubpopulations.size();
    }
}

