/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.mombi.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;

public abstract class AbstractUtilityFunctionsSet<S extends Solution<?>>
implements Serializable {
    private List<List<Double>> weightVectors;
    private int vectorSize;

    public AbstractUtilityFunctionsSet(double[][] weights) {
        this.weightVectors = new ArrayList<List<Double>>();
        for (int i = 0; i < weights.length; ++i) {
            this.weightVectors.add(new ArrayList());
            for (int j = 0; j < weights[i].length; ++j) {
                this.weightVectors.get(i).add(weights[i][j]);
            }
        }
        if (this.weightVectors.size() > 0) {
            this.vectorSize = this.weightVectors.get(0).size();
        }
    }

    public AbstractUtilityFunctionsSet(String file_path) {
        this.loadWeightsFromFile(file_path);
    }

    public int getSize() {
        return this.weightVectors.size();
    }

    public int getVectorSize() {
        return this.vectorSize;
    }

    public List<Double> getWeightVector(int index) {
        if (index < 0 && index >= this.weightVectors.size()) {
            throw new JMetalException("getWeightVector: index " + index + " invalid ");
        }
        return this.weightVectors.get(index);
    }

    public List<Double> evaluate(S solution) {
        ArrayList<Double> result = new ArrayList<Double>(this.getSize());
        for (int i = 0; i < this.getSize(); ++i) {
            result.add(this.evaluate(solution, i));
        }
        return result;
    }

    public abstract Double evaluate(S var1, int var2);

    public void loadWeightsFromFile(String filePath) {
        System.out.println("FILE PATH: " + filePath);
        InputStream in = this.getClass().getResourceAsStream("/" + filePath);
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader buffer = new BufferedReader(isr);
        String line = null;
        try {
            int number_of_objectives;
            line = buffer.readLine();
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            int number_of_weight_vectors = new Integer(st.nextToken());
            this.weightVectors = new ArrayList<List<Double>>(number_of_weight_vectors);
            this.vectorSize = number_of_objectives = new Integer(st.nextToken()).intValue();
            while ((line = buffer.readLine()) != null) {
                st = new StringTokenizer(line);
                ArrayList<Double> new_vector = new ArrayList<Double>(number_of_objectives);
                for (int i = 0; i < number_of_objectives; ++i) {
                    new_vector.add(new Double(st.nextToken()));
                }
                this.weightVectors.add(new_vector);
            }
        }
        catch (IOException e) {
            throw new JMetalException("loadWeightsFromFile: failed when reading for file: /" + filePath);
        }
    }
}

