/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.mombi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.AbstractUtilityFunctionsSet;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.Normalizer;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.R2Ranking;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.R2RankingAttribute;
import org.uma.jmetal.algorithm.multiobjective.mombi.util.R2SolutionData;
import org.uma.jmetal.solution.Solution;

public class R2RankingNormalized<S extends Solution<?>>
extends R2Ranking<S> {
    private List<List<S>> rankedSubpopulations;
    private int numberOfRanks = 0;
    private final Normalizer normalizer;

    public R2RankingNormalized(AbstractUtilityFunctionsSet<S> utilityFunctions, Normalizer normalizer) {
        super(utilityFunctions);
        this.normalizer = normalizer;
    }

    private double computeNorm(S solution) {
        ArrayList<Double> values = new ArrayList<Double>(solution.getNumberOfObjectives());
        for (int i = 0; i < solution.getNumberOfObjectives(); ++i) {
            if (this.normalizer == null) {
                values.add(solution.getObjective(i));
                continue;
            }
            values.add(this.normalizer.normalize(solution.getObjective(i), i));
        }
        double result = 0.0;
        for (Double d : values) {
            result += Math.pow(d, 2.0);
        }
        return Math.sqrt(result);
    }

    @Override
    public R2RankingNormalized<S> computeRanking(List<S> population) {
        for (Solution solution : population) {
            R2SolutionData data = new R2SolutionData();
            data.utility = this.computeNorm(solution);
            solution.setAttribute(this.getAttributeIdentifier(), data);
        }
        for (int i = 0; i < this.getUtilityFunctions().getSize(); ++i) {
            Object solution2;
            for (Object solution2 : population) {
                Object solutionData = this.getAttribute((Solution)solution2);
                ((R2SolutionData)solutionData).alpha = this.getUtilityFunctions().evaluate(solution2, i);
            }
            Collections.sort(population, new Comparator<S>(){

                @Override
                public int compare(S o1, S o2) {
                    R2RankingAttribute attribute = new R2RankingAttribute();
                    R2SolutionData data1 = (R2SolutionData)attribute.getAttribute(o1);
                    R2SolutionData data2 = (R2SolutionData)attribute.getAttribute(o2);
                    if (data1.alpha < data2.alpha) {
                        return -1;
                    }
                    if (data1.alpha > data2.alpha) {
                        return 1;
                    }
                    return 0;
                }
            });
            int rank = 1;
            solution2 = population.iterator();
            while (solution2.hasNext()) {
                Solution p = (Solution)solution2.next();
                Object r2Data = this.getAttribute(p);
                if (rank < ((R2SolutionData)r2Data).rank) {
                    ((R2SolutionData)r2Data).rank = rank;
                    this.numberOfRanks = Math.max(this.numberOfRanks, rank);
                }
                ++rank;
            }
        }
        TreeMap fronts = new TreeMap();
        for (Object solution2 : population) {
            Object r2Data = this.getAttribute((Solution)solution2);
            if (fronts.get(((R2SolutionData)r2Data).rank) == null) {
                fronts.put(((R2SolutionData)r2Data).rank, new LinkedList());
            }
            ((List)fronts.get(((R2SolutionData)r2Data).rank)).add(solution2);
        }
        this.rankedSubpopulations = new ArrayList<List<S>>(fronts.size());
        Iterator iterator = fronts.keySet().iterator();
        while (iterator.hasNext()) {
            this.rankedSubpopulations.add((List<S>)fronts.get(iterator.next()));
        }
        return this;
    }

    @Override
    public List<S> getSubfront(int rank) {
        return this.rankedSubpopulations.get(rank);
    }

    @Override
    public int getNumberOfSubfronts() {
        return this.rankedSubpopulations.size();
    }
}

