/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.nsgaii;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.ConstrainedProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;

public class NSGAIIStoppingByTime<S extends Solution<?>>
extends NSGAII<S> {
    private long initComputingTime = System.currentTimeMillis();
    private long thresholdComputingTime;
    private boolean stoppingCondition = false;

    public NSGAIIStoppingByTime(Problem<S> problem, int populationSize, long maxComputingTime, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, Comparator<S> dominanceComparator) {
        super(problem, 0, populationSize, crossoverOperator, mutationOperator, selectionOperator, dominanceComparator, null);
        this.thresholdComputingTime = maxComputingTime;
    }

    @Override
    protected void initProgress() {
        this.evaluations = this.getMaxPopulationSize();
    }

    @Override
    protected void updateProgress() {
    }

    @Override
    protected List<S> evaluatePopulation(List<S> population) {
        int index = 0;
        while (index < population.size() && !this.stoppingCondition) {
            if (this.getProblem() instanceof ConstrainedProblem) {
                this.getProblem().evaluate(population.get(index));
                ((ConstrainedProblem)this.getProblem()).evaluateConstraints(population.get(index));
            } else {
                this.getProblem().evaluate(population.get(index));
            }
            if (System.currentTimeMillis() - this.initComputingTime > this.thresholdComputingTime) {
                this.stoppingCondition = true;
                continue;
            }
            ++this.evaluations;
            ++index;
        }
        return population;
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.stoppingCondition;
    }

    @Override
    public String getName() {
        return "NSGAII";
    }

    @Override
    public String getDescription() {
        return "NSGAII";
    }
}

