/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.rnsgaii;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.selection.RankingAndPreferenceSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;

public class RNSGAII<S extends Solution<?>>
extends NSGAII<S> {
    private List<Double> interestPoint;
    private double epsilon;

    public RNSGAII(Problem<S> problem, int maxEvaluations, int populationSize, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, SolutionListEvaluator<S> evaluator, List<Double> interestPoint, double epsilon) {
        super(problem, maxEvaluations, populationSize, crossoverOperator, mutationOperator, selectionOperator, new DominanceComparator(), evaluator);
        this.interestPoint = interestPoint;
        this.epsilon = epsilon;
    }

    public void updateReferencePoint(List<Double> newReferencePoints) {
        this.interestPoint = newReferencePoints;
    }

    @Override
    protected void initProgress() {
        this.evaluations = this.getMaxPopulationSize();
    }

    @Override
    protected void updateProgress() {
        this.evaluations += this.getMaxPopulationSize();
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    @Override
    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        ArrayList<S> jointPopulation = new ArrayList<S>();
        jointPopulation.addAll(population);
        jointPopulation.addAll(offspringPopulation);
        RankingAndPreferenceSelection<S> rankingAndCrowdingSelection = new RankingAndPreferenceSelection<S>(this.getMaxPopulationSize(), this.interestPoint, this.epsilon);
        return rankingAndCrowdingSelection.execute((List<S>)jointPopulation);
    }

    @Override
    public List<S> getResult() {
        return this.getNonDominatedSolutions(this.getPopulation());
    }

    @Override
    public String getName() {
        return "RNSGAII";
    }

    @Override
    public String getDescription() {
        return "Nondominated Sorting Genetic Algorithm version II";
    }
}

