/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.rnsgaii;

import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.rnsgaii.RNSGAII;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.AlgorithmBuilder;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class RNSGAIIBuilder<S extends Solution<?>>
implements AlgorithmBuilder<RNSGAII<S>> {
    private final Problem<S> problem;
    private int maxEvaluations;
    private int populationSize;
    private CrossoverOperator<S> crossoverOperator;
    private MutationOperator<S> mutationOperator;
    private SelectionOperator<List<S>, S> selectionOperator;
    private SolutionListEvaluator<S> evaluator;
    private List<Double> interestPoint;
    private double epsilon;
    private NSGAIIVariant variant;

    public RNSGAIIBuilder(Problem<S> problem, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, List<Double> interestPoint, double epsilon) {
        this.problem = problem;
        this.maxEvaluations = 25000;
        this.populationSize = 100;
        this.crossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
        this.selectionOperator = new BinaryTournamentSelection(new RankingAndCrowdingDistanceComparator());
        this.evaluator = new SequentialSolutionListEvaluator();
        this.epsilon = epsilon;
        this.interestPoint = interestPoint;
        this.variant = NSGAIIVariant.NSGAII;
    }

    public RNSGAIIBuilder<S> setMaxEvaluations(int maxEvaluations) {
        if (maxEvaluations < 0) {
            throw new JMetalException("maxEvaluations is negative: " + maxEvaluations);
        }
        this.maxEvaluations = maxEvaluations;
        return this;
    }

    public RNSGAIIBuilder<S> setPopulationSize(int populationSize) {
        if (populationSize < 0) {
            throw new JMetalException("Population size is negative: " + populationSize);
        }
        this.populationSize = populationSize;
        return this;
    }

    public RNSGAIIBuilder<S> setSelectionOperator(SelectionOperator<List<S>, S> selectionOperator) {
        if (selectionOperator == null) {
            throw new JMetalException("selectionOperator is null");
        }
        this.selectionOperator = selectionOperator;
        return this;
    }

    public RNSGAIIBuilder<S> setSolutionListEvaluator(SolutionListEvaluator<S> evaluator) {
        if (evaluator == null) {
            throw new JMetalException("evaluator is null");
        }
        this.evaluator = evaluator;
        return this;
    }

    public RNSGAIIBuilder<S> setVariant(NSGAIIVariant variant) {
        this.variant = variant;
        return this;
    }

    @Override
    public RNSGAII<S> build() {
        RNSGAII<S> algorithm = null;
        algorithm = new RNSGAII<S>(this.problem, this.maxEvaluations, this.populationSize, this.crossoverOperator, this.mutationOperator, this.selectionOperator, this.evaluator, this.interestPoint, this.epsilon);
        return algorithm;
    }

    public Problem<S> getProblem() {
        return this.problem;
    }

    public int getMaxIterations() {
        return this.maxEvaluations;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public CrossoverOperator<S> getCrossoverOperator() {
        return this.crossoverOperator;
    }

    public MutationOperator<S> getMutationOperator() {
        return this.mutationOperator;
    }

    public SelectionOperator<List<S>, S> getSelectionOperator() {
        return this.selectionOperator;
    }

    public SolutionListEvaluator<S> getSolutionListEvaluator() {
        return this.evaluator;
    }

    public static enum NSGAIIVariant {
        NSGAII,
        SteadyStateNSGAII,
        Measures,
        NSGAII45;

    }
}

