/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.rnsgaii.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.uma.jmetal.algorithm.multiobjective.rnsgaii.util.PreferenceNSGAII;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.GenericSolutionAttribute;
import org.uma.jmetal.util.solutionattribute.impl.NumberOfViolatedConstraints;

public class RNSGAIIRanking<S extends Solution<?>>
extends GenericSolutionAttribute<S, Integer>
implements Ranking<S> {
    private PreferenceNSGAII<S> utilityFunctions;
    private List<Double> referencePoint;
    private List<List<S>> rankedSubpopulations;
    private int numberOfRanks = 0;
    private double epsilon;
    private NumberOfViolatedConstraints<S> numberOfViolatedConstraints;

    public RNSGAIIRanking(PreferenceNSGAII<S> utilityFunctions, double epsilon, List<Double> interestPoint) {
        this.utilityFunctions = utilityFunctions;
        this.epsilon = epsilon;
        this.referencePoint = interestPoint;
        this.numberOfViolatedConstraints = new NumberOfViolatedConstraints();
    }

    @Override
    public Ranking<S> computeRanking(List<S> population) {
        int size = population.size();
        ArrayList<Double> upperBound = new ArrayList<Double>();
        ArrayList<Double> lowerBound = new ArrayList<Double>();
        int numberObjectives = ((Solution)population.get(0)).getNumberOfObjectives();
        for (int i = 0; i < ((Solution)population.get(0)).getNumberOfObjectives(); ++i) {
            Collections.sort(population, new ObjectiveComparator(i));
            double objetiveMinn = ((Solution)population.get(0)).getObjective(i);
            double objetiveMaxn = ((Solution)population.get(population.size() - 1)).getObjective(i);
            upperBound.add(objetiveMaxn);
            lowerBound.add(objetiveMinn);
        }
        this.utilityFunctions.setLowerBounds(lowerBound);
        this.utilityFunctions.setUpperBounds(upperBound);
        LinkedList<S> temporalList = new LinkedList<S>();
        temporalList.addAll(population);
        int indexReference = 0;
        this.numberOfRanks = population.size() + 1;
        this.rankedSubpopulations = new ArrayList<List<S>>(this.numberOfRanks);
        for (int i = 0; i < this.numberOfRanks - 1; ++i) {
            this.rankedSubpopulations.add(new ArrayList());
        }
        indexReference += numberObjectives;
        this.utilityFunctions.updatePointOfInterest(this.referencePoint);
        TreeMap map = new TreeMap();
        for (Solution solution : temporalList) {
            double value = this.utilityFunctions.evaluate(solution);
            List auxiliar = (List)map.get(value);
            if (auxiliar == null) {
                auxiliar = new ArrayList();
            }
            auxiliar.add(solution);
            map.put(value, auxiliar);
        }
        int rank = 0;
        ArrayList populationOrder = new ArrayList(map.values());
        for (List solutionList : populationOrder) {
            for (Solution solution : solutionList) {
                Integer nConstrains = (Integer)this.numberOfViolatedConstraints.getAttribute(solution);
                if (nConstrains != null && nConstrains == 0 || nConstrains == null) {
                    this.setAttribute(solution, rank);
                    this.rankedSubpopulations.get(rank).add(solution);
                    continue;
                }
                this.setAttribute(solution, Integer.MAX_VALUE);
                this.rankedSubpopulations.get(this.numberOfRanks - 2).add(solution);
            }
            ++rank;
        }
        while (!temporalList.isEmpty()) {
            int indexRandom = JMetalRandom.getInstance().nextInt(0, temporalList.size() - 1);
            Solution solutionRandom = (Solution)temporalList.get(indexRandom);
            temporalList.remove(indexRandom);
            for (int i = 0; i < temporalList.size(); ++i) {
                Solution solution;
                solution = (Solution)temporalList.get(i);
                double sum = this.preference(solutionRandom, solution, upperBound, lowerBound);
                if (!(sum < this.epsilon)) continue;
                this.setAttribute(solution, Integer.MAX_VALUE);
                List<S> rankListAux = this.rankedSubpopulations.get(this.rankedSubpopulations.size() - 1);
                if (rankListAux == null) {
                    rankListAux = new ArrayList<S>();
                }
                rankListAux.add(solution);
                temporalList.remove(i);
            }
        }
        return this;
    }

    private void removeRank(S solution) {
        boolean enc = false;
        for (int i = 0; i < this.rankedSubpopulations.size(); ++i) {
            while (this.rankedSubpopulations.get(i).contains(solution)) {
                this.rankedSubpopulations.get(i).remove(solution);
            }
        }
    }

    private double preference(S solution1, S solution2, List<Double> upperBounds, List<Double> lowerBounds) {
        double result = 0.0;
        for (int indexOfObjective = 0; indexOfObjective < solution1.getNumberOfObjectives(); ++indexOfObjective) {
            if (upperBounds != null && lowerBounds != null) {
                result += Math.abs(solution1.getObjective(indexOfObjective) - solution2.getObjective(indexOfObjective)) / (upperBounds.get(indexOfObjective) - lowerBounds.get(indexOfObjective));
                continue;
            }
            result += Math.abs(solution1.getObjective(indexOfObjective) - solution2.getObjective(indexOfObjective));
        }
        return result;
    }

    @Override
    public List<S> getSubfront(int rank) {
        return this.rankedSubpopulations.get(rank);
    }

    @Override
    public int getNumberOfSubfronts() {
        return this.rankedSubpopulations.size();
    }
}

