/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.smsemoa;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractGeneticAlgorithm;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.qualityindicator.impl.Hypervolume;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;

public class SMSEMOA<S extends Solution<?>>
extends AbstractGeneticAlgorithm<S, List<S>> {
    protected final int maxEvaluations;
    protected final double offset;
    protected int evaluations;
    private Hypervolume<S> hypervolume;

    public SMSEMOA(Problem<S> problem, int maxEvaluations, int populationSize, double offset, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, Hypervolume<S> hypervolumeImplementation) {
        super(problem);
        this.maxEvaluations = maxEvaluations;
        this.setMaxPopulationSize(populationSize);
        this.offset = offset;
        this.crossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
        this.selectionOperator = selectionOperator;
        this.hypervolume = hypervolumeImplementation;
    }

    @Override
    protected void initProgress() {
        this.evaluations = this.getMaxPopulationSize();
    }

    @Override
    protected void updateProgress() {
        ++this.evaluations;
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.evaluations >= this.maxEvaluations;
    }

    @Override
    protected List<S> evaluatePopulation(List<S> population) {
        for (Solution solution : population) {
            this.getProblem().evaluate(solution);
        }
        return population;
    }

    @Override
    protected List<S> selection(List<S> population) {
        ArrayList<Solution> matingPopulation = new ArrayList<Solution>(2);
        for (int i = 0; i < 2; ++i) {
            Solution solution = (Solution)this.selectionOperator.execute(population);
            matingPopulation.add(solution);
        }
        return matingPopulation;
    }

    @Override
    protected List<S> reproduction(List<S> population) {
        ArrayList offspringPopulation = new ArrayList(1);
        ArrayList<S> parents = new ArrayList<S>(2);
        parents.add(population.get(0));
        parents.add(population.get(1));
        List offspring = (List)this.crossoverOperator.execute(parents);
        this.mutationOperator.execute(offspring.get(0));
        offspringPopulation.add(offspring.get(0));
        return offspringPopulation;
    }

    @Override
    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        int i;
        ArrayList<S> jointPopulation = new ArrayList<S>();
        jointPopulation.addAll(population);
        jointPopulation.addAll(offspringPopulation);
        Ranking ranking = this.computeRanking(jointPopulation);
        List<Object> lastSubfront = ranking.getSubfront(ranking.getNumberOfSubfronts() - 1);
        lastSubfront = this.hypervolume.computeHypervolumeContribution(lastSubfront, jointPopulation);
        ArrayList<Object> resultPopulation = new ArrayList<Object>();
        for (i = 0; i < ranking.getNumberOfSubfronts() - 1; ++i) {
            for (Solution solution : ranking.getSubfront(i)) {
                resultPopulation.add(solution);
            }
        }
        for (i = 0; i < lastSubfront.size() - 1; ++i) {
            resultPopulation.add(lastSubfront.get(i));
        }
        return resultPopulation;
    }

    @Override
    public List<S> getResult() {
        return this.getPopulation();
    }

    protected Ranking<S> computeRanking(List<S> solutionList) {
        DominanceRanking<S> ranking = new DominanceRanking<S>();
        ranking.computeRanking(solutionList);
        return ranking;
    }

    @Override
    public String getName() {
        return "SMSEMOA";
    }

    @Override
    public String getDescription() {
        return "S metric selection EMOA";
    }
}

