/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.wasfga.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.uma.jmetal.util.JMetalException;

public class WeightVectors {
    public static boolean validate(double[][] weights, int numberOfComponents) {
        boolean correct = weights != null && weights.length > 0;
        for (int i = 0; correct && i < weights.length; ++i) {
            correct = weights[i].length == numberOfComponents;
        }
        return correct;
    }

    public static double[][] initializeUniformlyInTwoDimensions(double epsilon, int numberOfWeights) {
        double[][] weights = new double[numberOfWeights][2];
        double jump = (1.0 - 2.0 * epsilon) / (double)(numberOfWeights - 1);
        double w = epsilon;
        for (int indexOfWeight = 0; indexOfWeight < numberOfWeights; ++indexOfWeight) {
            weights[indexOfWeight][0] = w;
            weights[indexOfWeight][1] = 1.0 - w;
            w += jump;
        }
        return weights;
    }

    public static double[][] readFromResourcesInJMetal(String filePath) {
        double[][] weights;
        Vector<double[]> listOfWeights = new Vector<double[]>();
        try {
            InputStream in = WeightVectors.class.getResourceAsStream("/" + filePath);
            InputStreamReader isr = new InputStreamReader(in);
            BufferedReader br = new BufferedReader(isr);
            int numberOfObjectives = 0;
            String aux = br.readLine();
            while (aux != null) {
                StringTokenizer st = new StringTokenizer(aux);
                int j = 0;
                numberOfObjectives = st.countTokens();
                double[] weight = new double[numberOfObjectives];
                while (st.hasMoreTokens()) {
                    weight[j] = new Double(st.nextToken());
                    ++j;
                }
                listOfWeights.add(weight);
                aux = br.readLine();
            }
            br.close();
            weights = new double[listOfWeights.size()][numberOfObjectives];
            for (int indexWeight = 0; indexWeight < listOfWeights.size(); ++indexWeight) {
                System.arraycopy(listOfWeights.get(indexWeight), 0, weights[indexWeight], 0, numberOfObjectives);
            }
        }
        catch (Exception e) {
            throw new JMetalException("readFromResourcesInJMetal: failed when reading for file: " + filePath + "", e);
        }
        return weights;
    }

    public static double[][] readFromFile(String filePath) {
        double[][] weights;
        Vector<double[]> listOfWeights = new Vector<double[]>();
        try {
            FileInputStream fis = new FileInputStream(filePath);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            int numberOfObjectives = 0;
            String aux = br.readLine();
            while (aux != null) {
                StringTokenizer st = new StringTokenizer(aux);
                int j = 0;
                numberOfObjectives = st.countTokens();
                double[] weight = new double[numberOfObjectives];
                while (st.hasMoreTokens()) {
                    weight[j] = new Double(st.nextToken());
                    ++j;
                }
                listOfWeights.add(weight);
                aux = br.readLine();
            }
            br.close();
            weights = new double[listOfWeights.size()][numberOfObjectives];
            for (int indexWeight = 0; indexWeight < listOfWeights.size(); ++indexWeight) {
                System.arraycopy(listOfWeights.get(indexWeight), 0, weights[indexWeight], 0, numberOfObjectives);
            }
        }
        catch (Exception e) {
            throw new JMetalException("readFromFile: failed when reading for file: " + filePath + "", e);
        }
        return weights;
    }

    public static double[][] invert(double[][] weights, boolean normalize) {
        double[][] result = new double[weights.length][weights[0].length];
        for (int indexOfWeight = 0; indexOfWeight < weights.length; ++indexOfWeight) {
            if (normalize) {
                int indexOfComponent;
                double sum = 0.0;
                for (indexOfComponent = 0; indexOfComponent < weights[indexOfWeight].length; ++indexOfComponent) {
                    sum += 1.0 / weights[indexOfWeight][indexOfComponent];
                }
                for (indexOfComponent = 0; indexOfComponent < weights[indexOfWeight].length; ++indexOfComponent) {
                    result[indexOfWeight][indexOfComponent] = 1.0 / weights[indexOfWeight][indexOfComponent] / sum;
                }
                continue;
            }
            for (int indexOfComponent = 0; indexOfComponent < weights[indexOfWeight].length; ++indexOfComponent) {
                result[indexOfWeight][indexOfComponent] = 1.0 / weights[indexOfWeight][indexOfComponent];
            }
        }
        return result;
    }
}

