/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.singleobjective.coralreefsoptimization;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.singleobjective.coralreefsoptimization.CoralReefsOptimization;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.AlgorithmBuilder;
import org.uma.jmetal.util.JMetalException;

public class CoralReefsOptimizationBuilder<S extends Solution<?>>
implements AlgorithmBuilder<CoralReefsOptimization<S>> {
    private Problem<S> problem;
    private SelectionOperator<List<S>, S> selectionOperator;
    private CrossoverOperator<S> crossoverOperator;
    private MutationOperator<S> mutationOperator;
    private Comparator<S> comparator;
    private int maxEvaluations;
    private int N;
    private int M;
    private double rho;
    private double Fbs;
    private double Fbr;
    private double Fa;
    private double Fd;
    private double Pd;
    private int attemptsToSettle;

    public CoralReefsOptimizationBuilder(Problem<S> problem, SelectionOperator<List<S>, S> selectionOperator, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator) {
        this.problem = problem;
        this.selectionOperator = selectionOperator;
        this.crossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
    }

    public CoralReefsOptimizationBuilder<S> setComparator(Comparator<S> comparator) {
        if (comparator == null) {
            throw new JMetalException("Comparator is null!");
        }
        this.comparator = comparator;
        return this;
    }

    public CoralReefsOptimizationBuilder<S> setMaxEvaluations(int maxEvaluations) {
        if (maxEvaluations < 0) {
            throw new JMetalException("maxEvaluations is negative: " + maxEvaluations);
        }
        this.maxEvaluations = maxEvaluations;
        return this;
    }

    public CoralReefsOptimizationBuilder<S> setN(int n) {
        if (n < 0) {
            throw new JMetalException("N is negative: " + n);
        }
        this.N = n;
        return this;
    }

    public CoralReefsOptimizationBuilder<S> setM(int m) {
        if (m < 0) {
            throw new JMetalException("M is negative: " + m);
        }
        this.M = m;
        return this;
    }

    public CoralReefsOptimizationBuilder<S> setRho(double rho) {
        if (rho < 0.0) {
            throw new JMetalException("Rho is negative: " + rho);
        }
        this.rho = rho;
        return this;
    }

    public CoralReefsOptimizationBuilder<S> setFbs(double fbs) {
        if (fbs < 0.0) {
            throw new JMetalException("Fbs is negative: " + fbs);
        }
        this.Fbs = fbs;
        return this;
    }

    public CoralReefsOptimizationBuilder<S> setFbr(double fbr) {
        if (fbr < 0.0) {
            throw new JMetalException("Fbr is negative: " + fbr);
        }
        this.Fbr = fbr;
        return this;
    }

    public CoralReefsOptimizationBuilder<S> setFa(double fa) {
        if (fa < 0.0) {
            throw new JMetalException("Fa is negative: " + fa);
        }
        this.Fa = fa;
        return this;
    }

    public CoralReefsOptimizationBuilder<S> setFd(double fd) {
        if (fd < 0.0) {
            throw new JMetalException("Fd is negative: " + fd);
        }
        this.Fd = fd;
        return this;
    }

    public CoralReefsOptimizationBuilder<S> setPd(double pd) {
        if (pd < 0.0) {
            throw new JMetalException("Pd is negative: " + pd);
        }
        this.Pd = pd;
        return this;
    }

    public CoralReefsOptimizationBuilder<S> setAttemptsToSettle(int attemptsToSettle) {
        if (attemptsToSettle < 0) {
            throw new JMetalException("attemptsToSettle is negative: " + attemptsToSettle);
        }
        this.attemptsToSettle = attemptsToSettle;
        return this;
    }

    @Override
    public CoralReefsOptimization<S> build() {
        CoralReefsOptimization<S> algorithm = null;
        algorithm = new CoralReefsOptimization<S>(this.problem, this.maxEvaluations, this.comparator, this.selectionOperator, this.crossoverOperator, this.mutationOperator, this.N, this.M, this.rho, this.Fbs, this.Fa, this.Pd, this.attemptsToSettle);
        return algorithm;
    }

    public Problem<S> getProblem() {
        return this.problem;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public SelectionOperator<List<S>, S> getSelectionOperator() {
        return this.selectionOperator;
    }

    public CrossoverOperator<S> getCrossoverOperator() {
        return this.crossoverOperator;
    }

    public MutationOperator<S> getMutationOperator() {
        return this.mutationOperator;
    }

    public Comparator<S> getComparator() {
        return this.comparator;
    }

    public int getN() {
        return this.N;
    }

    public int getM() {
        return this.M;
    }

    public double getRho() {
        return this.rho;
    }

    public double getFbs() {
        return this.Fbs;
    }

    public double getFbr() {
        return this.Fbr;
    }

    public double getFa() {
        return this.Fa;
    }

    public double getFd() {
        return this.Fd;
    }

    public double getPd() {
        return this.Pd;
    }

    public int getAttemptsToSettle() {
        return this.attemptsToSettle;
    }
}

